/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.Iterator;
import org.crsh.text.Chunk;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.Text;
import org.crsh.text.ui.Element;
import org.crsh.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextElement
extends Element {
    final Iterable<Chunk> stream;
    final int minWidth;
    final int width;

    private static int width(int width, Iterator<Chunk> stream, Text current, Integer from) {
        while (current == null && stream.hasNext()) {
            Chunk next = stream.next();
            if (!(next instanceof Text)) continue;
            current = (Text)next;
            from = 0;
        }
        if (current == null) {
            return width;
        }
        int pos = Utils.indexOf(current.getText(), from, '\n');
        if (pos == -1) {
            return TextElement.width(width + current.getText().length() - from, stream, current, from);
        }
        return Math.max(width + pos - from, TextElement.width(0, stream, null, 0));
    }

    public TextElement(Iterable<Chunk> stream, int minWidth) {
        if (minWidth < 0) {
            throw new IllegalArgumentException("No negative min size allowed");
        }
        int width = TextElement.width(0, stream.iterator(), null, null);
        this.minWidth = Math.min(width, minWidth);
        this.stream = stream;
        this.width = width;
    }

    public TextElement(Iterable<Chunk> stream) {
        this(stream, 1);
    }

    @Override
    public Renderer renderer() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "TextElement[]";
    }

    @Override
    public TextElement style(Style.Composite style) {
        return (TextElement)super.style(style);
    }
}

