/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.pam;

import net.sf.jpam.Pam;
import net.sf.jpam.PamReturnValue;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAMPasswordAuthenticator
implements PasswordAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(PAMPasswordAuthenticator.class);
    private String service = "sshd";

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean authenticate(String username, String password, ServerSession session) {
        LOG.info("Authenticating user {} using PAM", (Object)username);
        PamReturnValue val = new Pam(this.service).authenticate(username, password);
        LOG.info("Result: {}", (Object)val);
        return PamReturnValue.PAM_SUCCESS.equals((Object)val);
    }
}

