/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InvocationContext;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.command.SessionContext;
import org.crsh.io.ProducerContext;
import org.crsh.io.ScreenContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.PipeLineFactory;
import org.crsh.shell.impl.command.PipeLineParser;
import org.crsh.text.Chunk;
import org.crsh.text.RenderPrintWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvocationContextImpl<P>
implements InvocationContext<P> {
    private final ProducerContext<P> producerContext;
    private final SessionContext sessionContext;
    private RenderPrintWriter writer;

    InvocationContextImpl(ProducerContext<P> producerContext, SessionContext sessionContext) {
        this.producerContext = producerContext;
        this.sessionContext = sessionContext;
    }

    @Override
    public RenderPrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new RenderPrintWriter(new ScreenContext<Chunk>(){

                @Override
                public int getWidth() {
                    return InvocationContextImpl.this.producerContext.getWidth();
                }

                @Override
                public int getHeight() {
                    return InvocationContextImpl.this.producerContext.getHeight();
                }

                @Override
                public void provide(Chunk element) throws IOException {
                    Class consumedType = InvocationContextImpl.this.producerContext.getConsumedType();
                    if (consumedType.isInstance(element)) {
                        Object p = consumedType.cast(element);
                        InvocationContextImpl.this.producerContext.provide(p);
                    }
                }

                @Override
                public void flush() throws IOException {
                    InvocationContextImpl.this.producerContext.flush();
                }
            });
        }
        return this.writer;
    }

    @Override
    public boolean takeAlternateBuffer() {
        return this.producerContext.takeAlternateBuffer();
    }

    @Override
    public boolean releaseAlternateBuffer() {
        return this.producerContext.releaseAlternateBuffer();
    }

    @Override
    public CommandInvoker<?, ?> resolve(String s) throws ScriptException, IOException {
        CRaSHSession session = (CRaSHSession)this.getSession();
        PipeLineParser parser = new PipeLineParser(s);
        PipeLineFactory factory = parser.parse();
        try {
            return factory.create(session);
        }
        catch (NoSuchCommandException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Class<P> getConsumedType() {
        return this.producerContext.getConsumedType();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.producerContext.getProperty(propertyName);
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.producerContext.readLine(msg, echo);
    }

    @Override
    public int getWidth() {
        return this.producerContext.getWidth();
    }

    @Override
    public int getHeight() {
        return this.producerContext.getHeight();
    }

    @Override
    public void provide(P element) throws IOException {
        this.producerContext.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.producerContext.flush();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.sessionContext.getSession();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.sessionContext.getAttributes();
    }
}

