/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.completers.EmptyCompleter;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterCompletion
extends Completion {
    private final String prefix;
    private final Delimiter delimiter;
    private final ParameterDescriptor<?> parameter;
    private final Completer completer;

    ParameterCompletion(String prefix, Delimiter delimiter, ParameterDescriptor<?> parameter, Completer completer) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.parameter = parameter;
        this.completer = completer;
    }

    @Override
    CommandCompletion complete() throws CmdCompletionException {
        Class<Completer> completerType = this.parameter.getCompleterType();
        Completer completer = this.completer;
        if (completerType != EmptyCompleter.class) {
            try {
                completer = completerType.newInstance();
            }
            catch (Exception e) {
                throw new CmdCompletionException(e);
            }
        }
        if (completer != null) {
            try {
                return new CommandCompletion(this.delimiter, completer.complete(this.parameter, this.prefix));
            }
            catch (Exception e) {
                throw new CmdCompletionException(e);
            }
        }
        return new CommandCompletion(this.delimiter, org.crsh.cmdline.spi.Completion.create());
    }
}

