/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.ssh.term.CRaSHCommand;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.crsh.text.Style;

public class SSHIO
implements TermIO {
    private static final int UP = 1001;
    private static final int DOWN = 1002;
    private static final int RIGHT = 1003;
    private static final int LEFT = 1004;
    private static final int HANDLED = 1305;
    private static final int BACKWARD_WORD = -1;
    private static final int FORWARD_WORD = -2;
    private static final Logger log = Logger.getLogger(SSHIO.class.getName());
    private final Reader reader;
    private final Writer writer;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_READ_ESC_1 = 1;
    private static final int STATUS_READ_ESC_2 = 2;
    private int status;
    private final CRaSHCommand command;
    final AtomicBoolean closed;

    public SSHIO(CRaSHCommand command) {
        this.command = command;
        this.writer = new OutputStreamWriter(command.out);
        this.reader = new InputStreamReader(command.in);
        this.status = 0;
        this.closed = new AtomicBoolean(false);
    }

    public int read() throws IOException {
        while (!this.closed.get()) {
            int r;
            try {
                r = this.reader.read();
            }
            catch (IOException e) {
                this.close();
                return 1305;
            }
            if (r == -1) {
                return 1305;
            }
            switch (this.status) {
                case 0: {
                    if (r == 27) {
                        this.status = 1;
                        break;
                    }
                    return r;
                }
                case 1: {
                    if (r == 91) {
                        this.status = 2;
                        break;
                    }
                    if (r == 98) {
                        this.status = 0;
                        return -1;
                    }
                    if (r == 102) {
                        this.status = 0;
                        return -2;
                    }
                    this.status = 0;
                    log.log(Level.SEVERE, "Unrecognized stream data " + r + " after reading ESC code");
                    break;
                }
                case 2: {
                    this.status = 0;
                    switch (r) {
                        case 65: {
                            return 1001;
                        }
                        case 66: {
                            return 1002;
                        }
                        case 67: {
                            return 1003;
                        }
                        case 68: {
                            return 1004;
                        }
                    }
                    log.log(Level.SEVERE, "Unrecognized stream data " + r + " after reading ESC+91 code");
                }
            }
        }
        return 1305;
    }

    public int getWidth() {
        return this.command.getContext().getWidth();
    }

    public int getHeight() {
        return this.command.getContext().getHeight();
    }

    public String getProperty(String name) {
        return this.command.getContext().getProperty(name);
    }

    public CodeType decode(int code) {
        if (code == this.command.getContext().verase) {
            return CodeType.BACKSPACE;
        }
        switch (code) {
            case 1305: {
                return CodeType.CLOSE;
            }
            case 1: {
                return CodeType.BEGINNING_OF_LINE;
            }
            case 5: {
                return CodeType.END_OF_LINE;
            }
            case 3: {
                return CodeType.BREAK;
            }
            case 9: {
                return CodeType.TAB;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
            case 1004: {
                return CodeType.LEFT;
            }
            case 1003: {
                return CodeType.RIGHT;
            }
            case -1: {
                return CodeType.BACKWARD_WORD;
            }
            case -2: {
                return CodeType.FORWARD_WORD;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
        if (this.closed.get()) {
            log.log(Level.FINE, "Attempt to closed again");
        } else {
            log.log(Level.FINE, "Closing SSHIO");
            this.command.session.close(false);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(CharSequence s) throws IOException {
        this.writer.write(((Object)s).toString());
    }

    public void write(char c) throws IOException {
        this.writer.write(c);
    }

    public void write(Style d) throws IOException {
        d.writeAnsiTo((Appendable)this.writer);
    }

    public void writeDel() throws IOException {
        this.writer.write("\u001b[D \u001b[D");
    }

    public void writeCRLF() throws IOException {
        this.writer.write("\r\n");
    }

    public boolean moveRight(char c) throws IOException {
        this.writer.write(c);
        return true;
    }

    public boolean moveLeft() throws IOException {
        this.writer.write("\u001b[");
        this.writer.write("1D");
        return true;
    }

    public void cls() throws IOException {
        this.writer.write("\u001b[");
        this.writer.write("2J");
        this.writer.write("\u001b[");
        this.writer.write("1;1H");
    }
}

