/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IllegalParameterException;
import org.crsh.cmdline.IllegalValueTypeException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.ParameterType;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentDescriptor<B extends TypeBinding>
extends ParameterDescriptor<B> {
    private final String name;

    public ArgumentDescriptor(B binding, String name, ParameterType<?> type, Description info, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        super(binding, type, info, required, password, unquote, completerType, annotation);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object parse(List<String> values) throws CmdSyntaxException {
        if (this.getMultiplicity() == Multiplicity.SINGLE) {
            if (values.size() > 1) {
                throw new CmdSyntaxException("Too many option values " + values);
            }
            String value = values.get(0);
            try {
                return this.parse(value);
            }
            catch (Exception e) {
                throw new CmdSyntaxException("Could not parse " + value);
            }
        }
        ArrayList<Object> v = new ArrayList<Object>(values.size());
        for (String value : values) {
            try {
                v.add(this.parse(value));
            }
            catch (Exception e) {
                throw new CmdSyntaxException("Could not parse " + value);
            }
        }
        return v;
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        if (this.getMultiplicity() == Multiplicity.MULTI) {
            writer.append("... ");
        }
        writer.append(this.name == null || this.name.length() == 0 ? "arg" : this.name);
    }

    public String toString() {
        return "ArgumentDescriptor[" + this.name + "]";
    }
}

