/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.io.Serializable;
import java.util.Collections;
import org.crsh.shell.ErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShellResponse
implements Serializable {
    public static UnknownCommand unknownCommand(String name) {
        return new UnknownCommand(name);
    }

    public static NoCommand noCommand() {
        return NoCommand.INSTANCE;
    }

    public static Ok ok(Iterable<?> produced) {
        return new Ok(produced);
    }

    public static Ok ok() {
        return new Ok();
    }

    public static Error evalError(String msg, Throwable throwable) {
        return new Error(ErrorType.EVALUATION, msg, throwable);
    }

    public static Error evalError(String msg) {
        return new Error(ErrorType.EVALUATION, msg);
    }

    public static Error internalError(String msg, Throwable throwable) {
        return new Error(ErrorType.INTERNAL, msg, throwable);
    }

    public static Error internalError(String msg) {
        return new Error(ErrorType.INTERNAL, msg);
    }

    public static Error error(ErrorType type, String msg, Throwable throwable) {
        return new Error(type, msg, throwable);
    }

    public static Error error(ErrorType type, String msg) {
        return new Error(type, msg);
    }

    public static Cancelled cancelled() {
        return Cancelled.INSTANCE;
    }

    public static Close close() {
        return Close.INSTANCE;
    }

    public abstract String getMessage();

    public static class Error
    extends ShellResponse {
        private final ErrorType type;
        private final Throwable throwable;
        private final String msg;

        private Error(ErrorType type, String msg) {
            this.type = type;
            this.msg = msg;
            this.throwable = null;
        }

        private Error(ErrorType type, String msg, Throwable throwable) {
            this.type = type;
            this.msg = msg;
            this.throwable = throwable;
        }

        public ErrorType getType() {
            return this.type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return "ShellResponse.Error[type=" + (Object)((Object)this.type) + ",msg=" + this.msg + "]";
        }
    }

    public static class Cancelled
    extends ShellResponse {
        private static final Cancelled INSTANCE = new Cancelled();

        private Cancelled() {
        }

        public String getMessage() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ok
    extends ShellResponse {
        private final transient Iterable<?> produced;

        private Ok() {
            this(Collections.emptyList());
        }

        private Ok(Iterable<?> produced) {
            this.produced = produced;
        }

        public Iterable<?> getProduced() {
            return this.produced;
        }

        @Override
        public String getMessage() {
            return "";
        }
    }

    public static class Close
    extends ShellResponse {
        private static final Close INSTANCE = new Close();

        private Close() {
        }

        public String getMessage() {
            return "Have a good day!\r\n";
        }
    }

    public static class NoCommand
    extends ShellResponse {
        private static final NoCommand INSTANCE = new NoCommand();

        private NoCommand() {
        }

        public String getMessage() {
            return "Please type something";
        }
    }

    public static class UnknownCommand
    extends ShellResponse {
        private final String name;

        private UnknownCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getMessage() {
            return this.name + ": command not found";
        }

        public String toString() {
            return "UnknownCommand[" + this.name + "]";
        }
    }
}

