/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.shell.impl.command.Pipe;
import org.crsh.text.Chunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipeLine
implements CommandInvoker<Void, Chunk> {
    private final CommandInvoker[] invokers;
    private Pipe.Invoker current;

    PipeLine(CommandInvoker[] invokers) {
        this.invokers = invokers;
        this.current = null;
    }

    @Override
    public Class<Void> getConsumedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<Chunk> getProducedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPiped(boolean piped) {
        throw new UnsupportedOperationException("This should not be called");
    }

    @Override
    public void open(CommandContext<Chunk> consumer) {
        this.open(0, consumer);
    }

    private CommandContext open(int index, CommandContext last) {
        if (index < this.invokers.length) {
            CommandInvoker invoker = this.invokers[index];
            Pipe next = this.open(index + 1, last);
            Class produced = invoker.getProducedType();
            Class consumed = next.getConsumedType();
            if (!consumed.isAssignableFrom(produced)) {
                Pipe filter;
                if (produced.equals(Void.class) || consumed.equals(Void.class)) {
                    filter = new Pipe.Sink(consumed);
                    ((Pipe.Sink)filter).open(next);
                    next = filter;
                } else if (consumed.equals(Chunk.class)) {
                    filter = new Pipe.Chunkizer();
                    ((Pipe.Chunkizer)filter).open(next);
                    next = filter;
                } else {
                    filter = new Pipe.Sink(consumed);
                    ((Pipe.Sink)filter).open(next);
                    next = filter;
                }
            }
            Pipe.Invoker filterContext = new Pipe.Invoker(invoker);
            filterContext.setPiped(index > 0);
            filterContext.open(next);
            this.current = filterContext;
            return filterContext;
        }
        return last;
    }

    @Override
    public void provide(Void element) throws IOException {
        throw new UnsupportedOperationException("This is not yet implemented");
    }

    @Override
    public void flush() throws IOException {
        this.current.flush();
    }

    @Override
    public void close() {
        this.current.close();
    }
}

