/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.util.Safe;

public final class CloseableList
implements Closeable {
    final Logger log = Logger.getLogger(CloseableList.class.getName());
    private final ArrayList<Closeable> closeables = new ArrayList();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public boolean isClosed() {
        return this.closed.get();
    }

    public void add(Closeable closeable) throws IllegalStateException, NullPointerException {
        if (this.closed.get()) {
            throw new IllegalStateException("Already closed");
        }
        if (closeable == null) {
            throw new NullPointerException("No null closeable accepted");
        }
        if (!this.closeables.contains(closeable)) {
            this.closeables.add(closeable);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (Closeable closeable : this.closeables) {
                this.log.log(Level.FINE, "Closing " + closeable.getClass().getSimpleName());
                Safe.close(closeable);
            }
        }
    }
}

