/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.impl.lang.ClassFieldBinding;
import org.crsh.cli.impl.lang.MethodDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassDescriptor<T>
extends CommandDescriptorImpl<T> {
    private final Class<T> type;
    private final Map<String, MethodDescriptor<T>> methods;

    ClassDescriptor(Class<T> type, Map<String, MethodDescriptor<T>> methods, Description info) throws IntrospectionException {
        super(type.getSimpleName().toLowerCase(), info);
        this.methods = methods;
        this.type = type;
    }

    @Override
    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException {
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            HashSet<String> blah = new HashSet<String>();
            for (String string : option.getNames()) {
                blah.add((string.length() == 1 ? "-" : "--") + string);
            }
            for (MethodDescriptor methodDescriptor : this.methods.values()) {
                HashSet<String> diff = new HashSet<String>(methodDescriptor.getOptionNames());
                diff.retainAll(blah);
                if (diff.size() <= 0) continue;
                throw new IntrospectionException("Cannot add method " + methodDescriptor.getName() + " because it has common " + " options with its class: " + diff);
            }
        }
        super.addParameter(parameter);
    }

    @Override
    public CommandInvoker<T> getInvoker(final InvocationMatch<T> match) {
        if (Runnable.class.isAssignableFrom(this.type)) {
            return new CommandInvoker<T>(){

                @Override
                public Class<?> getReturnType() {
                    return Void.class;
                }

                @Override
                public Type getGenericReturnType() {
                    return Void.class;
                }

                @Override
                public Class<?>[] getParameterTypes() {
                    return new Class[0];
                }

                @Override
                public Type[] getGenericParameterTypes() {
                    return new Type[0];
                }

                @Override
                public Object invoke(Resolver resolver, T command) throws InvocationException, SyntaxException {
                    ClassDescriptor.this.configure(match, command);
                    Runnable runnable = (Runnable)Runnable.class.cast(command);
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        throw new InvocationException(e);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    void configure(InvocationMatch<T> classMatch, T command) throws InvocationException, SyntaxException {
        for (ParameterDescriptor parameter : this.getParameters()) {
            ParameterMatch<ParameterDescriptor> match = classMatch.getParameter(parameter);
            if (match == null) {
                if (!parameter.isRequired()) continue;
                if (parameter instanceof ArgumentDescriptor) {
                    ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
                    throw new SyntaxException("Missing argument " + argument.getName());
                }
                OptionDescriptor option = (OptionDescriptor)parameter;
                throw new SyntaxException("Missing option " + option.getNames());
            }
            Object value = match.computeValue();
            Field f = ((ClassFieldBinding)parameter.getBinding()).getField();
            try {
                f.setAccessible(true);
                f.set(command, value);
            }
            catch (Exception e) {
                throw new InvocationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public CommandDescriptor<T> getOwner() {
        return null;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Map<String, ? extends MethodDescriptor<T>> getSubordinates() {
        return this.methods;
    }

    @Override
    public MethodDescriptor<T> getSubordinate(String name) {
        return this.methods.get(name);
    }
}

