/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.term.CodeType;
import org.crsh.term.Term;
import org.crsh.term.TermEvent;
import org.crsh.term.console.TermIOBuffer;
import org.crsh.term.console.TermIOWriter;
import org.crsh.term.spi.TermIO;
import org.crsh.text.CLS;
import org.crsh.text.Chunk;
import org.crsh.text.Style;
import org.crsh.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleTerm
implements Term {
    private final Logger log = Logger.getLogger(ConsoleTerm.class.getName());
    private final LinkedList<CharSequence> history = new LinkedList();
    private CharSequence historyBuffer = null;
    private int historyCursor = -1;
    private final TermIO io;
    private final TermIOBuffer buffer;
    private final TermIOWriter writer;

    public ConsoleTerm(TermIO io) {
        this.io = io;
        this.buffer = new TermIOBuffer(io);
        this.writer = new TermIOWriter(io);
    }

    @Override
    public int getWidth() {
        return this.io.getWidth();
    }

    @Override
    public int getHeight() {
        return this.io.getHeight();
    }

    @Override
    public String getProperty(String name) {
        return this.io.getProperty(name);
    }

    @Override
    public void setEcho(boolean echo) {
        this.buffer.setEchoing(echo);
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        return this.io.takeAlternateBuffer();
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        return this.io.releaseAlternateBuffer();
    }

    @Override
    public TermEvent read() throws IOException {
        block14: do {
            int code = this.io.read();
            CodeType type = this.io.decode(code);
            switch (type) {
                case CLOSE: {
                    return TermEvent.close();
                }
                case BACKSPACE: {
                    this.buffer.del();
                    break;
                }
                case UP: 
                case DOWN: {
                    CharSequence s;
                    int nextHistoryCursor = this.historyCursor + (type == CodeType.UP ? 1 : -1);
                    if (nextHistoryCursor < -1 || nextHistoryCursor >= this.history.size()) continue block14;
                    CharSequence charSequence = s = nextHistoryCursor == -1 ? this.historyBuffer : this.history.get(nextHistoryCursor);
                    while (this.buffer.moveRight()) {
                    }
                    CharSequence t = this.buffer.replace(s);
                    if (this.historyCursor == -1) {
                        this.historyBuffer = t;
                    }
                    if (nextHistoryCursor == -1) {
                        this.historyBuffer = null;
                    }
                    this.historyCursor = nextHistoryCursor;
                    break;
                }
                case RIGHT: {
                    this.buffer.moveRight();
                    break;
                }
                case LEFT: {
                    this.buffer.moveLeft();
                    break;
                }
                case BREAK: {
                    this.log.log(Level.FINE, "Want to cancel evaluation");
                    this.buffer.clear();
                    return TermEvent.brk();
                }
                case CHAR: {
                    if (code >= 0 && code < 128) {
                        this.buffer.append((char)code);
                        break;
                    }
                    this.log.log(Level.FINE, "Unhandled char " + code);
                    break;
                }
                case TAB: {
                    this.log.log(Level.FINE, "Tab");
                    return TermEvent.complete(this.buffer.getBufferToCursor());
                }
                case BACKWARD_WORD: {
                    int cursor;
                    int pos;
                    for (pos = cursor = this.buffer.getCursor(); pos > 0 && this.buffer.charAt(pos - 1) == ' '; --pos) {
                    }
                    while (pos > 0 && this.buffer.charAt(pos - 1) != ' ') {
                        --pos;
                    }
                    if (pos >= cursor) break;
                    this.buffer.moveLeft(cursor - pos);
                    break;
                }
                case FORWARD_WORD: {
                    int cursor;
                    int pos;
                    int size = this.buffer.getSize();
                    for (pos = cursor = this.buffer.getCursor(); pos < size && this.buffer.charAt(pos) == ' '; ++pos) {
                    }
                    while (pos < size && this.buffer.charAt(pos) != ' ') {
                        ++pos;
                    }
                    if (pos <= cursor) break;
                    this.buffer.moveRight(pos - cursor);
                    break;
                }
                case BEGINNING_OF_LINE: {
                    int cursor = this.buffer.getCursor();
                    if (cursor <= 0) break;
                    this.buffer.moveLeft(cursor);
                    break;
                }
                case END_OF_LINE: {
                    int cursor = this.buffer.getSize() - this.buffer.getCursor();
                    if (cursor <= 0) break;
                    this.buffer.moveRight(cursor);
                    break;
                }
            }
        } while (!this.buffer.hasNext());
        this.historyCursor = -1;
        this.historyBuffer = null;
        CharSequence input = this.buffer.next();
        return TermEvent.readLine(input);
    }

    @Override
    public Appendable getDirectBuffer() {
        return this.buffer;
    }

    @Override
    public void addToHistory(CharSequence line) {
        this.history.addFirst(line);
    }

    @Override
    public CharSequence getBuffer() {
        return this.buffer.getBufferToCursor();
    }

    @Override
    public void flush() {
        try {
            this.io.flush();
        }
        catch (IOException e) {
            this.log.log(Level.FINE, "Exception thrown during term flush()", e);
        }
    }

    @Override
    public void close() {
        try {
            this.log.log(Level.FINE, "Closing connection");
            this.io.flush();
            this.io.close();
        }
        catch (IOException e) {
            this.log.log(Level.FINE, "Exception thrown during term close()", e);
        }
    }

    @Override
    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    @Override
    public void provide(Chunk element) throws IOException {
        if (element == null) {
            throw new NullPointerException("No null chunk accepted");
        }
        if (element instanceof Text) {
            Text textChunk = (Text)element;
            this.writer.write(textChunk.getText());
        } else if (element instanceof Style) {
            this.io.write((Style)element);
        } else if (element instanceof CLS) {
            this.io.cls();
        } else {
            throw new UnsupportedOperationException("todo");
        }
    }
}

