/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.crsh.text.Chunk;
import org.crsh.text.Renderer;
import org.crsh.text.Text;
import org.crsh.text.ui.LabelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Renderable<E> {
    private static final Renderable<?>[] renderables;
    public static Renderable<Object> ANY;

    public static <I> Renderable<? super I> getRenderable(Class<I> itemType) {
        for (Renderable<?> formatter : renderables) {
            if (!formatter.getType().isAssignableFrom(itemType)) continue;
            return formatter;
        }
        return null;
    }

    public abstract Class<E> getType();

    public abstract Renderer renderer(Iterator<E> var1);

    static {
        ArrayList<Renderable> tmp = new ArrayList<Renderable>();
        Iterator<Renderable> i = ServiceLoader.load(Renderable.class).iterator();
        while (i.hasNext()) {
            try {
                Renderable renderable = i.next();
                tmp.add(renderable);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {}
        }
        renderables = tmp.toArray(new Renderable[tmp.size()]);
        ANY = new Renderable<Object>(){

            @Override
            public Class<Object> getType() {
                return Object.class;
            }

            @Override
            public Renderer renderer(Iterator<Object> stream) {
                StringBuilder sb = new StringBuilder();
                while (stream.hasNext()) {
                    Object next = stream.next();
                    if (next instanceof Chunk) {
                        if (!(next instanceof Text)) continue;
                        sb.append((CharSequence)((Text)next).buffer);
                        continue;
                    }
                    sb.append(next);
                }
                return new LabelElement(sb.toString()).renderer();
            }
        };
    }
}

