/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsType
extends ASTNode {
    private final ClassNode[] upperBounds;
    private final ClassNode lowerBound;
    private ClassNode type;
    private String name;
    private boolean placeholder;
    private boolean resolved;
    private boolean wildcard;

    public GenericsType(ClassNode type, ClassNode[] upperBounds, ClassNode lowerBound) {
        this.type = type;
        this.name = type.isGenericsPlaceHolder() ? type.getUnresolvedName() : type.getName();
        this.upperBounds = upperBounds;
        this.lowerBound = lowerBound;
        this.placeholder = type.isGenericsPlaceHolder();
        this.resolved = false;
    }

    public GenericsType(ClassNode basicType) {
        this(basicType, null, null);
    }

    public ClassNode getType() {
        return this.type;
    }

    public void setType(ClassNode type) {
        this.type = type;
    }

    public String toString() {
        HashSet<String> visited = new HashSet<String>();
        return this.toString(visited);
    }

    private String toString(Set<String> visited) {
        String ret;
        if (this.placeholder) {
            visited.add(this.name);
        }
        String string = ret = this.type == null || this.placeholder || this.wildcard ? this.name : this.genericsBounds(this.type, visited);
        if (this.upperBounds != null) {
            ret = ret + " extends ";
            for (int i = 0; i < this.upperBounds.length; ++i) {
                ret = ret + this.genericsBounds(this.upperBounds[i], visited);
                if (i + 1 >= this.upperBounds.length) continue;
                ret = ret + " & ";
            }
        } else if (this.lowerBound != null) {
            ret = ret + " super " + this.genericsBounds(this.lowerBound, visited);
        }
        return ret;
    }

    private String genericsBounds(ClassNode theType, Set<String> visited) {
        StringBuilder ret = new StringBuilder();
        if (theType.isArray()) {
            ret.append(theType.getComponentType().getName());
            ret.append("[]");
        } else if (theType.redirect() instanceof InnerClassNode) {
            InnerClassNode innerClassNode = (InnerClassNode)theType.redirect();
            String parentClassNodeName = innerClassNode.getOuterClass().getName();
            ret.append(this.genericsBounds(innerClassNode.getOuterClass(), new HashSet<String>()));
            ret.append(".");
            String typeName = theType.getName();
            ret.append(typeName.substring(parentClassNodeName.length() + 1));
        } else {
            ret.append(theType.getName());
        }
        GenericsType[] genericsTypes = theType.getGenericsTypes();
        if (genericsTypes == null || genericsTypes.length == 0) {
            return ret.toString();
        }
        if (genericsTypes.length == 1 && genericsTypes[0].isPlaceholder() && theType.getName().equals("java.lang.Object")) {
            return genericsTypes[0].getName();
        }
        ret.append("<");
        for (int i = 0; i < genericsTypes.length; ++i) {
            GenericsType type;
            if (i != 0) {
                ret.append(", ");
            }
            if ((type = genericsTypes[i]).isPlaceholder() && visited.contains(type.getName())) {
                ret.append(type.getName());
                continue;
            }
            ret.append(type.toString(visited));
        }
        ret.append(">");
        return ret.toString();
    }

    public ClassNode[] getUpperBounds() {
        return this.upperBounds;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(boolean placeholder) {
        this.placeholder = placeholder;
        this.type.setGenericsPlaceHolder(placeholder);
    }

    public boolean isResolved() {
        return this.resolved || this.placeholder;
    }

    public void setResolved(boolean res) {
        this.resolved = res;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    public ClassNode getLowerBound() {
        return this.lowerBound;
    }
}

