/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.net.ConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortListener
implements Runnable {
    private static Log log = LogFactory.getLog(class$net$wimpi$telnetd$net$PortListener == null ? (class$net$wimpi$telnetd$net$PortListener = PortListener.class$("net.wimpi.telnetd.net.PortListener")) : class$net$wimpi$telnetd$net$PortListener);
    private String m_Name;
    private int m_Port;
    private int m_FloodProtection;
    private ServerSocket m_ServerSocket = null;
    private Thread m_Thread;
    private ConnectionManager connectionManager;
    private boolean m_Stopping = false;
    private boolean m_Available;
    private static final String logmsg = "Listening to Port {0,number,integer} with a connectivity queue size of {1,number,integer}.";
    static /* synthetic */ Class class$net$wimpi$telnetd$net$PortListener;

    public PortListener(String name, int port, int floodprot) {
        this.m_Name = name;
        this.m_Available = false;
        this.m_Port = port;
        this.m_FloodProtection = floodprot;
    }

    public String getName() {
        return this.m_Name;
    }

    public boolean isAvailable() {
        return this.m_Available;
    }

    public void setAvailable(boolean b) {
        this.m_Available = b;
    }

    public void start() {
        log.debug("start()");
        this.m_Thread = new Thread(this);
        this.m_Thread.start();
        this.m_Available = true;
    }

    public void stop() {
        log.debug("stop()::" + this.toString());
        this.m_Stopping = true;
        this.m_Available = false;
        this.connectionManager.stop();
        try {
            this.m_ServerSocket.close();
        }
        catch (IOException ex) {
            log.error("stop()", ex);
        }
        try {
            this.m_Thread.join();
        }
        catch (InterruptedException iex) {
            log.error("stop()", iex);
        }
        log.info("stop()::Stopped " + this.toString());
    }

    public void run() {
        try {
            this.m_ServerSocket = new ServerSocket(this.m_Port, this.m_FloodProtection);
            Object[] args = new Object[]{new Integer(this.m_Port), new Integer(this.m_FloodProtection)};
            log.info(MessageFormat.format(logmsg, args));
            do {
                try {
                    Socket s = this.m_ServerSocket.accept();
                    if (this.m_Available) {
                        this.connectionManager.makeConnection(s);
                        continue;
                    }
                    s.close();
                }
                catch (SocketException ex) {
                    if (this.m_Stopping) {
                        log.debug("run(): ServerSocket closed by stop()");
                        continue;
                    }
                    log.error("run()", ex);
                }
            } while (!this.m_Stopping);
        }
        catch (IOException e) {
            log.error("run()", e);
        }
        log.debug("run(): returning.");
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static PortListener createPortListener(String name, Properties settings) throws BootException {
        PortListener pl = null;
        try {
            int port = Integer.parseInt(settings.getProperty(name + ".port"));
            int floodprot = Integer.parseInt(settings.getProperty(name + ".floodprotection"));
            if (new Boolean(settings.getProperty(name + ".secure")).booleanValue()) {
                // empty if block
            }
            pl = new PortListener(name, port, floodprot);
        }
        catch (Exception ex) {
            log.error("createPortListener()", ex);
            throw new BootException("Failure while creating PortListener instance:\n" + ex.getMessage());
        }
        if (pl.connectionManager == null) {
            pl.connectionManager = ConnectionManager.createConnectionManager(name, settings);
            try {
                pl.connectionManager.start();
            }
            catch (Exception exc) {
                log.error("createPortListener()", exc);
                throw new BootException("Failure while starting ConnectionManager watchdog thread:\n" + exc.getMessage());
            }
        }
        return pl;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

