/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.shell.impl.command.Pipe;
import org.crsh.shell.impl.command.PipeFilter;
import org.crsh.text.Chunk;

class PipeLine
implements CommandInvoker<Void, Chunk> {
    private final CommandInvoker[] invokers;
    private Pipe current;

    PipeLine(CommandInvoker[] invokers) {
        this.invokers = invokers;
        this.current = null;
    }

    @Override
    public Class<Void> getConsumedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<Chunk> getProducedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void open(CommandContext<Chunk> consumer) {
        this.open(0, consumer);
    }

    private CommandContext open(int index, CommandContext last) {
        if (index < this.invokers.length) {
            PipeFilter filter;
            boolean piped;
            CommandInvoker invoker = this.invokers[index];
            PipeFilter next = this.open(index + 1, last);
            Class produced = invoker.getProducedType();
            Class consumed = next.getConsumedType();
            boolean bl = piped = index > 0;
            if (!consumed.isAssignableFrom(produced)) {
                if (produced.equals(Void.class) || consumed.equals(Void.class)) {
                    filter = new PipeFilter.Sink(consumed, piped);
                    ((PipeFilter.Sink)filter).open(next);
                    next = filter;
                } else if (consumed.equals(Chunk.class)) {
                    filter = new PipeFilter.Chunkizer(piped);
                    ((PipeFilter.Chunkizer)filter).open(next);
                    next = filter;
                } else {
                    filter = new PipeFilter.Sink(consumed, piped);
                    ((PipeFilter.Sink)filter).open(next);
                    next = filter;
                }
            } else {
                filter = new PipeFilter.Noop(piped);
                ((PipeFilter.Noop)filter).open(next);
                next = filter;
            }
            Pipe filterContext = new Pipe(invoker);
            filterContext.open(next);
            this.current = filterContext;
            return filterContext;
        }
        return last;
    }

    @Override
    public void provide(Void element) throws IOException {
        throw new UnsupportedOperationException("This is not yet implemented");
    }

    @Override
    public void flush() throws IOException {
        this.current.flush();
    }

    @Override
    public void close() {
        this.current.close();
    }
}

