/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.IvyTask;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.XmlReportOutputter;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.XSLTProcess;
import org.apache.tools.ant.util.JAXPUtils;

public class IvyReport
extends IvyTask {
    private File todir;
    private String organisation;
    private String module;
    private String conf;
    private boolean graph = true;
    private boolean dot = false;
    private boolean xml = false;
    private boolean xsl = true;
    private File xslFile;
    private String outputpattern;
    private String xslext = "html";
    private List params = new ArrayList();
    private String resolveId;
    private ModuleRevisionId mRevId;

    public File getTodir() {
        return this.todir;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setCache(File cache) {
        this.cacheAttributeNotSupported();
    }

    public String getConf() {
        return this.conf;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public boolean isGraph() {
        return this.graph;
    }

    public void setGraph(boolean graph) {
        this.graph = graph;
    }

    public File getXslfile() {
        return this.xslFile;
    }

    public void setXslfile(File xslFile) {
        this.xslFile = xslFile;
    }

    public String getOutputpattern() {
        return this.outputpattern;
    }

    public void setOutputpattern(String outputpattern) {
        this.outputpattern = outputpattern;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public void setResolveId(String resolveId) {
        this.resolveId = resolveId;
    }

    public void doExecute() throws BuildException {
        String t;
        Ivy ivy = this.getIvyInstance();
        IvySettings settings = ivy.getSettings();
        this.conf = this.getProperty(this.conf, settings, "ivy.resolved.configurations", this.resolveId);
        if ("*".equals(this.conf)) {
            this.conf = this.getProperty(settings, "ivy.resolved.configurations", this.resolveId);
        }
        if (this.conf == null) {
            throw new BuildException("no conf provided for ivy report task: It can either be set explicitely via the attribute 'conf' or via 'ivy.resolved.configurations' property or a prior call to <resolve/>");
        }
        if (this.todir == null && (t = this.getProperty(settings, "ivy.report.todir")) != null) {
            this.todir = this.getProject().resolveFile(t);
        }
        if (this.todir != null && this.todir.exists()) {
            this.todir.mkdirs();
        }
        this.outputpattern = this.getProperty(this.outputpattern, settings, "ivy.report.output.pattern");
        if (this.outputpattern == null) {
            this.outputpattern = "[organisation]-[module]-[conf].[ext]";
        }
        if (this.todir != null && this.todir.exists() && !this.todir.isDirectory()) {
            throw new BuildException("destination directory should be a directory !");
        }
        if (this.resolveId == null) {
            this.organisation = this.getProperty(this.organisation, settings, "ivy.organisation", this.resolveId);
            this.module = this.getProperty(this.module, settings, "ivy.module", this.resolveId);
            if (this.organisation == null) {
                throw new BuildException("no organisation provided for ivy report task: It can either be set explicitely via the attribute 'organisation' or via 'ivy.organisation' property or a prior call to <resolve/>");
            }
            if (this.module == null) {
                throw new BuildException("no module name provided for ivy report task: It can either be set explicitely via the attribute 'module' or via 'ivy.module' property or a prior call to <resolve/>");
            }
            this.resolveId = ResolveOptions.getDefaultResolveId(new ModuleId(this.organisation, this.module));
        }
        try {
            String[] confs = this.splitConfs(this.conf);
            if (this.xsl) {
                this.genreport(confs);
            }
            if (this.xml) {
                this.genxml(confs);
            }
            if (this.graph) {
                this.genStyled(confs, this.getStylePath("ivy-report-graph.xsl"), "graphml");
            }
            if (this.dot) {
                this.genStyled(confs, this.getStylePath("ivy-report-dot.xsl"), "dot");
            }
        }
        catch (IOException e) {
            throw new BuildException("impossible to generate report: " + e, (Throwable)e);
        }
    }

    private void genxml(String[] confs) throws IOException {
        ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
        for (int i = 0; i < confs.length; ++i) {
            File xml = cacheMgr.getConfigurationResolveReportInCache(this.resolveId, confs[i]);
            File out = this.todir != null ? new File(this.todir, this.getOutputPattern(confs[i], "xml")) : this.getProject().resolveFile(this.getOutputPattern(confs[i], "xml"));
            FileUtil.copy(xml, out, null);
        }
    }

    private void genreport(String[] confs) throws IOException {
        File css;
        this.genStyled(confs, this.getReportStylePath(), this.xslext);
        if (this.xslFile == null && !(css = this.todir != null ? new File(this.todir, "ivy-report.css") : this.getProject().resolveFile("ivy-report.css")).exists()) {
            Message.debug("copying report css to " + css.getAbsolutePath());
            FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.css"), css, null);
        }
    }

    private File getReportStylePath() throws IOException {
        if (this.xslFile != null) {
            return this.xslFile;
        }
        ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
        File style = new File(cacheMgr.getResolutionCacheRoot(), "ivy-report.xsl");
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream("ivy-report.xsl"), style, null);
        return style;
    }

    private String getOutputPattern(String conf, String ext) {
        if (this.mRevId == null) {
            ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
            XmlReportParser parser = new XmlReportParser();
            File reportFile = cacheMgr.getConfigurationResolveReportInCache(this.resolveId, conf);
            try {
                parser.parse(reportFile);
            }
            catch (ParseException e) {
                throw new BuildException("Error occurred while parsing reportfile '" + reportFile.getAbsolutePath() + "'", (Throwable)e);
            }
            this.mRevId = parser.getResolvedModule();
        }
        return IvyPatternHelper.substitute(this.outputpattern, this.mRevId.getOrganisation(), this.mRevId.getName(), this.mRevId.getRevision(), "", "", ext, conf, this.mRevId.getAttributes(), null);
    }

    private void genStyled(String[] confs, File style, String ext) throws IOException {
        ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
        File out = this.todir != null ? this.todir : this.getProject().getBaseDir();
        InputStream xsltStream = null;
        try {
            xsltStream = new BufferedInputStream(new FileInputStream(style));
            StreamSource xsltSource = new StreamSource(xsltStream, JAXPUtils.getSystemId((File)style));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xsltSource);
            transformer.setParameter("confs", this.conf);
            transformer.setParameter("extension", this.xslext);
            Iterator it = this.params.iterator();
            while (it.hasNext()) {
                XSLTProcess.Param param = (XSLTProcess.Param)it.next();
                transformer.setParameter(param.getName(), param.getExpression());
            }
            for (int i = 0; i < confs.length; ++i) {
                File reportFile = cacheMgr.getConfigurationResolveReportInCache(this.resolveId, confs[i]);
                File outFile = new File(out, this.getOutputPattern(confs[i], ext));
                this.log("Processing " + reportFile + " to " + outFile);
                File outFileDir = outFile.getParentFile();
                if (!outFileDir.exists() && !outFileDir.mkdirs()) {
                    throw new BuildException("Unable to create directory: " + outFileDir.getAbsolutePath());
                }
                InputStream inStream = null;
                OutputStream outStream = null;
                try {
                    inStream = new BufferedInputStream(new FileInputStream(reportFile));
                    outStream = new BufferedOutputStream(new FileOutputStream(outFile));
                    StreamResult res = new StreamResult(outStream);
                    StreamSource src = new StreamSource(inStream, JAXPUtils.getSystemId((File)style));
                    transformer.transform(src, res);
                    continue;
                }
                catch (TransformerException e) {
                    throw new BuildException((Throwable)e);
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {}
                    }
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        catch (TransformerConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (xsltStream != null) {
                try {
                    xsltStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private File getStylePath(String styleResourceName) throws IOException {
        ResolutionCacheManager cacheMgr = this.getIvyInstance().getResolutionCacheManager();
        File style = new File(cacheMgr.getResolutionCacheRoot(), styleResourceName);
        FileUtil.copy(XmlReportOutputter.class.getResourceAsStream(styleResourceName), style, null);
        return style;
    }

    public boolean isXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean isXsl() {
        return this.xsl;
    }

    public void setXsl(boolean xsl) {
        this.xsl = xsl;
    }

    public String getXslext() {
        return this.xslext;
    }

    public void setXslext(String xslext) {
        this.xslext = xslext;
    }

    public XSLTProcess.Param createParam() {
        XSLTProcess.Param result = new XSLTProcess.Param();
        this.params.add(result);
        return result;
    }

    public boolean isDot() {
        return this.dot;
    }

    public void setDot(boolean dot) {
        this.dot = dot;
    }
}

