/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.url;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.crsh.util.Safe;
import org.crsh.vfs.spi.url.InputStreamResolver;

abstract class ZipIterator
implements Closeable {
    ZipIterator() {
    }

    static ZipIterator create(URL url) throws IOException, URISyntaxException {
        if (url.getProtocol().equals("file")) {
            return ZipIterator.create(new File(url.toURI()));
        }
        if (url.getProtocol().equals("jar")) {
            int pos = url.getPath().lastIndexOf("!/");
            URL jarURL = new URL(url.getPath().substring(0, pos));
            String path = url.getPath().substring(pos + 2);
            final ZipIterator container = ZipIterator.create(jarURL);
            ZipIterator zip = null;
            try {
                while (container.hasNext()) {
                    ZipEntry entry = container.next();
                    if (!entry.getName().equals(path)) continue;
                    InputStreamResolver resolved = container.open();
                    final InputStream nested = resolved.open();
                    InputStream filter = new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return nested.read();
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            return nested.read(b);
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return nested.read(b, off, len);
                        }

                        @Override
                        public long skip(long n) throws IOException {
                            return nested.skip(n);
                        }

                        @Override
                        public int available() throws IOException {
                            return nested.available();
                        }

                        @Override
                        public void close() throws IOException {
                            Safe.close(nested);
                            Safe.close(container);
                        }

                        @Override
                        public synchronized void mark(int readlimit) {
                            nested.mark(readlimit);
                        }

                        @Override
                        public synchronized void reset() throws IOException {
                            nested.reset();
                        }

                        @Override
                        public boolean markSupported() {
                            return nested.markSupported();
                        }
                    };
                    zip = ZipIterator.create(filter);
                    break;
                }
                if (zip != null) {
                    ZipIterator zipIterator = zip;
                    return zipIterator;
                }
                throw new IOException("Cannot resolve " + url);
            }
            finally {
                if (zip != null) {
                    Safe.close(container);
                }
            }
        }
        return ZipIterator.create(url.openStream());
    }

    static ZipIterator create(File file) throws IOException {
        final ZipFile jarFile = new ZipFile(file);
        final Enumeration<? extends ZipEntry> en = jarFile.entries();
        en.hasMoreElements();
        return new ZipIterator(){
            ZipEntry next;

            @Override
            boolean hasNext() throws IOException {
                return en.hasMoreElements();
            }

            @Override
            ZipEntry next() throws IOException {
                this.next = (ZipEntry)en.nextElement();
                return this.next;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            InputStreamResolver open() throws IOException {
                final ZipEntry capture = this.next;
                return new InputStreamResolver(){

                    @Override
                    public InputStream open() throws IOException {
                        return jarFile.getInputStream(capture);
                    }
                };
            }
        };
    }

    static ZipIterator create(InputStream in) throws IOException {
        final byte[] tmp = new byte[512];
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final ZipInputStream zip = new ZipInputStream(in);
        return new ZipIterator(){
            ZipEntry next;

            @Override
            boolean hasNext() throws IOException {
                if (this.next == null) {
                    this.next = zip.getNextEntry();
                }
                return this.next != null;
            }

            @Override
            ZipEntry next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ZipEntry tmp2 = this.next;
                this.next = null;
                return tmp2;
            }

            @Override
            InputStreamResolver open() throws IOException {
                int len;
                while ((len = zip.read(tmp, 0, tmp.length)) != -1) {
                    baos.write(tmp, 0, len);
                }
                final byte[] buffer = baos.toByteArray();
                baos.reset();
                return new InputStreamResolver(){

                    @Override
                    public InputStream open() throws IOException {
                        return new ByteArrayInputStream(buffer);
                    }
                };
            }

            @Override
            public void close() throws IOException {
                zip.close();
            }
        };
    }

    abstract boolean hasNext() throws IOException;

    abstract ZipEntry next() throws IOException;

    abstract InputStreamResolver open() throws IOException;
}

