/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.invocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.LiteralValue;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.ArgumentMatch;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.OptionMatch;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.parser.Parser;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.impl.tokenizer.Tokenizer;
import org.crsh.cli.impl.tokenizer.TokenizerImpl;

public class InvocationMatcher<T> {
    private final CommandDescriptorImpl<T> descriptor;
    private final String mainName;

    public InvocationMatcher(CommandDescriptorImpl<T> descriptor, String mainName) {
        this.descriptor = descriptor;
        this.mainName = mainName;
    }

    public InvocationMatch<T> match(String name, Map<String, ?> options, List<?> arguments) throws SyntaxException {
        class TokenizerImpl
        extends ArrayList<Token> {
            TokenizerImpl() {
            }

            int last() {
                return this.size() > 0 ? ((Token)this.get(this.size() - 1)).getTo() : 0;
            }

            @Override
            public boolean add(Token token) {
                if (this.size() > 0) {
                    super.add(new Token.Whitespace(this.last(), " "));
                }
                return super.add(token);
            }

            public void addOption(String name) {
                if (name.length() == 1) {
                    this.add(new Token.Literal.Option.Short(this.last(), "-" + name));
                } else {
                    this.add(new Token.Literal.Option.Long(this.last(), "--" + name));
                }
            }
        }
        final TokenizerImpl t = new TokenizerImpl();
        if (name != null && name.length() > 0) {
            t.add(new Token.Literal.Word(t.last(), name));
        }
        for (Map.Entry<String, ?> option : options.entrySet()) {
            if (option.getValue() instanceof Boolean) {
                if (!((Boolean)option.getValue()).booleanValue()) continue;
                t.addOption(option.getKey());
                continue;
            }
            t.addOption(option.getKey());
            t.add(new Token.Literal.Word(t.last(), option.getValue().toString()));
        }
        for (Map.Entry<String, Object> argument : arguments) {
            t.add(new Token.Literal.Word(t.last(), argument.toString()));
        }
        Tokenizer tokenizer = new Tokenizer(){
            Iterator<Token> i;
            {
                this.i = t.iterator();
            }

            @Override
            protected Token parse() {
                return this.i.hasNext() ? this.i.next() : null;
            }

            @Override
            public Delimiter getDelimiter() {
                return Delimiter.EMPTY;
            }
        };
        return this.match(tokenizer);
    }

    public InvocationMatch<T> match(String s) throws SyntaxException {
        return this.match(new TokenizerImpl(s));
    }

    private InvocationMatch<T> match(Tokenizer tokenizer) throws SyntaxException {
        InvocationMatch<T> current;
        block9: {
            Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Mode.INVOKE);
            current = new InvocationMatch<T>(this.descriptor);
            while (true) {
                Event.Argument argumentEvent;
                List values;
                Event event;
                if ((event = parser.next()) instanceof Event.Separator) {
                    continue;
                }
                if (event instanceof Event.Stop) {
                    InvocationMatch<T> sub;
                    while ((sub = current.subordinate(this.mainName)) != null) {
                        current = sub;
                    }
                    break block9;
                }
                if (event instanceof Event.Option) {
                    Event.Option optionEvent = (Event.Option)event;
                    OptionDescriptor desc = (OptionDescriptor)optionEvent.getParameter();
                    Collection<OptionMatch> options = current.options();
                    OptionMatch option = null;
                    for (OptionMatch om : options) {
                        if (!((OptionDescriptor)om.getParameter()).equals(desc)) continue;
                        ArrayList<LiteralValue> v = new ArrayList<LiteralValue>(om.getValues());
                        v.addAll(this.bilto(optionEvent.getValues()));
                        ArrayList<String> names = new ArrayList<String>(om.getNames());
                        names.add(optionEvent.getToken().getName());
                        option = new OptionMatch(desc, names, v);
                        break;
                    }
                    if (option == null) {
                        option = new OptionMatch(desc, optionEvent.getToken().getName(), this.bilto(optionEvent.getValues()));
                    }
                    current.option(option);
                    continue;
                }
                if (event instanceof Event.Subordinate) {
                    current = current.subordinate(((Event.Subordinate)event).getDescriptor().getName());
                    continue;
                }
                if (!(event instanceof Event.Argument) || (values = (argumentEvent = (Event.Argument)event).getValues()).size() <= 0) continue;
                ArgumentMatch match = new ArgumentMatch((ArgumentDescriptor)argumentEvent.getParameter(), argumentEvent.getFrom(), argumentEvent.getTo(), this.bilto(argumentEvent.getValues()));
                if (argumentEvent.getCommand() != current.getDescriptor()) break;
                current.argument(match);
            }
            throw new AssertionError();
        }
        StringBuilder rest = new StringBuilder();
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            rest.append(token.getRaw());
        }
        current.setRest(rest.toString());
        return current;
    }

    private List<LiteralValue> bilto(List<? extends Token.Literal> literals) {
        ArrayList<LiteralValue> values = new ArrayList<LiteralValue>(literals.size());
        for (Token.Literal literal : literals) {
            values.add(new LiteralValue(literal.getRaw(), literal.getValue()));
        }
        return values;
    }
}

