/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.url;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import org.crsh.util.Safe;
import org.crsh.vfs.spi.url.InputStreamResolver;
import org.crsh.vfs.spi.url.ZipIterator;

public class Node {
    final String name;
    HashMap<String, Node> children = new HashMap();
    LinkedList<File> files = new LinkedList();

    public Node() {
        this.name = "";
    }

    private Node(String name) {
        this.name = name;
    }

    void merge(ClassLoader loader) throws IOException, URISyntaxException {
        Enumeration<URL> i = loader.getResources("");
        while (i.hasMoreElements()) {
            URL url = i.nextElement();
            this.merge(url);
        }
        ArrayList<URL> items = Collections.list(loader.getResources("META-INF/MANIFEST.MF"));
        for (URL item : items) {
            if (!"jar".equals(item.getProtocol())) continue;
            String path = item.getPath();
            int pos = path.indexOf("!/");
            URL url = new URL(path.substring(0, pos));
            this.merge(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void merge(URL url) throws IOException, URISyntaxException {
        if (url.getProtocol().equals("file")) {
            try {
                java.io.File f = new java.io.File(url.toURI());
                if (f.isDirectory()) {
                    this.merge(f);
                    return;
                }
                if (!f.getName().endsWith(".jar")) return;
                this.merge(new URL("jar:" + url + "!/"));
                return;
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        } else if (url.getProtocol().equals("jar")) {
            int pos = url.getPath().lastIndexOf("!/");
            URL jarURL = new URL(url.getPath().substring(0, pos));
            String path = url.getPath().substring(pos + 2);
            ZipIterator i = ZipIterator.create(jarURL);
            try {
                while (i.hasNext()) {
                    ZipEntry entry = i.next();
                    if (!entry.getName().startsWith(path)) continue;
                    this.add(url, entry.getName().substring(path.length()), i.open());
                }
                return;
            }
            finally {
                Safe.close(i);
            }
        } else {
            if (!url.getPath().endsWith(".jar")) return;
            this.merge(new URL("jar:" + url + "!/"));
        }
    }

    private void merge(java.io.File f) throws IOException {
        java.io.File[] files = f.listFiles();
        if (files != null) {
            for (final java.io.File file : files) {
                String name = file.getName();
                Node child = this.children.get(name);
                if (file.isDirectory()) {
                    if (child == null) {
                        Node dir = new Node(name);
                        dir.merge(file);
                        this.children.put(name, dir);
                        continue;
                    }
                    child.merge(file);
                    continue;
                }
                if (child == null) {
                    child = new Node(name);
                    this.children.put(name, child);
                }
                child.files.add(new File(new InputStreamResolver(){

                    @Override
                    public InputStream open() throws IOException {
                        return new FileInputStream(file);
                    }
                }, file.lastModified()));
            }
        }
    }

    private void add(URL baseURL, String entryName, InputStreamResolver resolver) throws IOException {
        if (entryName.length() > 0 && entryName.charAt(entryName.length() - 1) != '/') {
            this.add(baseURL, 0, entryName, 1L, resolver);
        }
    }

    private void add(URL baseURL, int index, String entryName, long lastModified, InputStreamResolver resolver) throws IOException {
        int next = entryName.indexOf(47, index);
        if (next == -1) {
            String name = entryName.substring(index);
            Node child = this.children.get(name);
            if (child == null) {
                child = new Node(name);
                this.children.put(name, child);
            }
            child.files.add(new File(resolver, lastModified));
        } else {
            String name = entryName.substring(index, next);
            Node child = this.children.get(name);
            if (child == null) {
                child = new Node(name);
                this.children.put(name, child);
            }
            child.add(baseURL, next + 1, entryName, lastModified, resolver);
        }
    }

    static class File {
        final InputStreamResolver resolver;
        final long lastModified;

        File(InputStreamResolver url, long lastModified) {
            this.resolver = url;
            this.lastModified = lastModified;
        }
    }
}

