/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command.pipeline;

import java.io.IOException;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.pipeline.AbstractPipe;
import org.crsh.command.pipeline.ConvertingPipe;
import org.crsh.command.pipeline.PipeLineElement;
import org.crsh.command.pipeline.ToChunkPipe;
import org.crsh.text.Chunk;

public class PipeLine
extends CommandInvoker<Void, Chunk> {
    private final CommandInvoker[] invokers;
    private CommandContext<?> current;

    public PipeLine(CommandInvoker[] invokers) {
        this.invokers = invokers;
        this.current = null;
    }

    @Override
    public Class<Void> getConsumedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<Chunk> getProducedType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void open(CommandContext<? super Chunk> consumer) {
        this.open(0, consumer);
    }

    private CommandContext open(int index, CommandContext last) {
        if (index < this.invokers.length) {
            CommandInvoker invoker = this.invokers[index];
            CommandContext next = this.open(index + 1, last);
            Class produced = invoker.getProducedType();
            Class consumed = next.getConsumedType();
            boolean piped = index > 0;
            AbstractPipe filter = consumed.equals(Chunk.class) ? new ToChunkPipe(produced, piped) : new ConvertingPipe(produced, consumed, piped);
            filter.open(next);
            next = filter;
            PipeLineElement filterContext = new PipeLineElement(invoker);
            filterContext.open(next);
            this.current = filterContext;
            return filterContext;
        }
        this.current = last;
        return last;
    }

    @Override
    public void provide(Void element) throws IOException {
        throw new UnsupportedOperationException("This is not yet implemented");
    }

    @Override
    public void flush() throws IOException {
        this.current.flush();
    }

    @Override
    public void close() throws IOException {
        this.current.close();
    }
}

