/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command.pipeline;

import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.command.ScriptException;
import org.crsh.io.Filter;
import org.crsh.text.Chunk;

class PipeLineElement<C, P>
implements Filter<C, P, CommandContext<P>>,
CommandContext<C> {
    protected CommandContext<P> context;
    final Filter<C, P, CommandContext<P>> command;
    final Class<C> consumedType;

    PipeLineElement(Filter<C, P, CommandContext<P>> command) {
        this.command = command;
        this.consumedType = command.getConsumedType();
    }

    @Override
    public final boolean takeAlternateBuffer() throws IOException {
        return this.context.takeAlternateBuffer();
    }

    @Override
    public final boolean releaseAlternateBuffer() throws IOException {
        return this.context.releaseAlternateBuffer();
    }

    @Override
    public final String getProperty(String propertyName) {
        return this.context.getProperty(propertyName);
    }

    @Override
    public final String readLine(String msg, boolean echo) {
        return this.context.readLine(msg, echo);
    }

    @Override
    public final int getWidth() {
        return this.context.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.context.getHeight();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.context.getSession();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.context.getAttributes();
    }

    @Override
    public boolean isPiped() {
        return this.context.isPiped();
    }

    @Override
    public Class<P> getProducedType() {
        return this.command.getProducedType();
    }

    @Override
    public Class<C> getConsumedType() {
        return this.command.getConsumedType();
    }

    @Override
    public void open(CommandContext<P> consumer) {
        this.context = consumer;
        this.command.open(consumer);
    }

    @Override
    public void write(Chunk chunk) throws IOException {
        if (this.consumedType.isInstance(chunk)) {
            this.provide(this.consumedType.cast(chunk));
        } else {
            this.context.write(chunk);
        }
    }

    @Override
    public void provide(C element) throws IOException {
        this.command.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.command.flush();
    }

    @Override
    public void close() throws ScriptException, IOException {
        this.command.close();
    }
}

