/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.groovy.command;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.InvocationContext;
import org.crsh.command.InvocationContextImpl;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.RuntimeContext;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.lang.groovy.closure.PipeLineClosure;
import org.crsh.lang.groovy.closure.PipeLineInvoker;
import org.crsh.lang.groovy.command.GroovyCommand;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.text.RenderPrintWriter;
import org.crsh.util.Strings;

public abstract class GroovyScriptCommand
extends Script
implements ShellCommand {
    private LinkedList<InvocationContext<?>> stack = null;
    protected InvocationContext context;
    protected RenderPrintWriter out;
    private String[] args;
    private final CommandInvoker<Object, Object> invoker = new CommandInvoker<Object, Object>(){

        @Override
        public final Class<Object> getProducedType() {
            return Object.class;
        }

        @Override
        public final Class<Object> getConsumedType() {
            return Object.class;
        }

        @Override
        public void open(CommandContext<? super Object> consumer) {
            Binding binding = new Binding(consumer.getSession());
            binding.setProperty("args", (Object)GroovyScriptCommand.this.args);
            GroovyScriptCommand.this.setBinding(binding);
            GroovyScriptCommand.this.pushContext(new InvocationContextImpl<Object>(consumer));
            try {
                RenderPrintWriter writer;
                Object res = GroovyScriptCommand.this.run();
                if (res instanceof Closure) {
                    Closure closure = (Closure)res;
                    res = closure.call((Object[])GroovyScriptCommand.this.args);
                }
                if (res != null && (writer = GroovyScriptCommand.this.peekContext().getWriter()).isEmpty()) {
                    writer.print(res);
                }
            }
            catch (Exception t) {
                throw GroovyCommand.unwrap(t);
            }
        }

        @Override
        public void provide(Object element) throws IOException {
        }

        @Override
        public void flush() throws IOException {
            GroovyScriptCommand.this.peekContext().flush();
        }

        @Override
        public void close() throws IOException, UndeclaredThrowableException {
            GroovyScriptCommand.this.popContext();
        }
    };

    protected GroovyScriptCommand() {
    }

    public final void pushContext(InvocationContext<?> context) throws NullPointerException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.stack.addLast(this.context);
        this.context = context;
        this.out = context.getWriter();
    }

    public final InvocationContext<?> popContext() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot pop a context anymore from the stack");
        }
        InvocationContext context = this.context;
        this.context = this.stack.removeLast();
        this.out = this.context != null ? this.context.getWriter() : null;
        return context;
    }

    public final void execute(String s) throws ScriptException, IOException {
        InvocationContext<?> context = this.peekContext();
        CommandInvoker<?, ?> invoker = context.resolve(s);
        invoker.invoke(context);
    }

    public final InvocationContext<?> peekContext() {
        return this.context;
    }

    public final Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException missing) {
            CRaSH crash;
            if (this.context instanceof InvocationContext && (crash = (CRaSH)this.context.getSession().get("crash")) != null) {
                ShellCommand cmd;
                try {
                    cmd = crash.getCommand(name);
                }
                catch (NoSuchCommandException ce) {
                    throw new InvokerInvocationException((Throwable)ce);
                }
                if (cmd != null) {
                    InvocationContext<Object> ic = this.peekContext();
                    PipeLineClosure closure = new PipeLineClosure(ic, name, cmd);
                    PipeLineInvoker evaluation = closure.bind(args);
                    try {
                        evaluation.invoke(ic);
                        return null;
                    }
                    catch (IOException e) {
                        throw new GroovyRuntimeException((Throwable)e);
                    }
                    catch (UndeclaredThrowableException e) {
                        throw new GroovyRuntimeException(e.getCause());
                    }
                }
            }
            throw missing;
        }
    }

    public final Object getProperty(String property) {
        CRaSH crash;
        if ("out".equals(property)) {
            if (this.context instanceof InvocationContext) {
                return this.context.getWriter();
            }
            return null;
        }
        if ("context".equals(property)) {
            return this.context;
        }
        if (this.context instanceof InvocationContext && (crash = (CRaSH)this.context.getSession().get("crash")) != null) {
            try {
                ShellCommand cmd = crash.getCommand(property);
                if (cmd != null) {
                    InvocationContext<Object> ic = this.peekContext();
                    return new PipeLineClosure(ic, property, cmd);
                }
            }
            catch (NoSuchCommandException e) {
                throw new InvokerInvocationException((Throwable)e);
            }
        }
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return null;
        }
    }

    @Override
    public final CompletionMatch complete(RuntimeContext context, String line) {
        return new CompletionMatch(Delimiter.EMPTY, Completion.create());
    }

    @Override
    public final String describe(String line, DescriptionFormat mode) {
        return null;
    }

    @Override
    public final CommandInvoker<?, ?> resolveInvoker(String line) {
        List<String> chunks = Strings.chunks(line);
        this.args = chunks.toArray(new String[chunks.size()]);
        return this.invoker;
    }

    @Override
    public final CommandInvoker<?, ?> resolveInvoker(String name, Map<String, ?> options, List<?> args) {
        String[] tmp = new String[args.size()];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = args.get(i).toString();
        }
        this.args = tmp;
        return this.invoker;
    }
}

