/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.script;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.command.BaseRuntimeContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ShellCommand;
import org.crsh.lang.script.PipeLineFactory;
import org.crsh.lang.script.PipeLineParser;
import org.crsh.plugin.ResourceKind;
import org.crsh.repl.EvalResponse;
import org.crsh.repl.REPL;
import org.crsh.repl.REPLSession;
import org.crsh.shell.ShellResponse;
import org.crsh.text.Chunk;
import org.crsh.util.Utils;

public class ScriptREPL
implements REPL {
    static final Logger log = Logger.getLogger(ScriptREPL.class.getName());

    @Override
    public String getName() {
        return "script";
    }

    @Override
    public EvalResponse eval(REPLSession session, String request) {
        PipeLineParser parser = new PipeLineParser(request);
        PipeLineFactory factory = parser.parse();
        if (factory != null) {
            try {
                CommandInvoker<Void, Chunk> invoker = factory.create(session);
                return new EvalResponse.Invoke(invoker);
            }
            catch (NoSuchCommandException e) {
                return new EvalResponse.Response(ShellResponse.unknownCommand(e.getCommandName()));
            }
        }
        return new EvalResponse.Response(ShellResponse.noCommand());
    }

    @Override
    public CompletionMatch complete(REPLSession session, String prefix) {
        CompletionMatch completion;
        String termPrefix;
        PipeLineFactory ast = new PipeLineParser(prefix).parse();
        if (ast != null) {
            PipeLineFactory last = ast.getLast();
            termPrefix = Utils.trimLeft(last.getLine());
        } else {
            termPrefix = "";
        }
        log.log(Level.FINE, "Retained term prefix is " + prefix);
        int pos = termPrefix.indexOf(32);
        if (pos == -1) {
            Completion.Builder builder = Completion.builder((String)prefix);
            for (String resourceId : session.getContext().listResourceId(ResourceKind.COMMAND)) {
                if (!resourceId.startsWith(termPrefix)) continue;
                builder.add(resourceId.substring(termPrefix.length()), true);
            }
            completion = new CompletionMatch(Delimiter.EMPTY, builder.build());
        } else {
            String commandName = termPrefix.substring(0, pos);
            termPrefix = termPrefix.substring(pos);
            try {
                ShellCommand command = session.getCommand(commandName);
                completion = command != null ? command.complete(new BaseRuntimeContext(session, session.getContext().getAttributes()), termPrefix) : new CompletionMatch(Delimiter.EMPTY, Completion.create());
            }
            catch (NoSuchCommandException e) {
                log.log(Level.FINE, "Could not create command for completion of " + prefix, e);
                completion = new CompletionMatch(Delimiter.EMPTY, Completion.create());
            }
        }
        return completion;
    }
}

