/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.io.Consumer;
import org.crsh.shell.ScreenContext;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkAdapter;
import org.crsh.text.ChunkBuffer;

class CRaSHProcessContext
implements CommandContext<Object>,
Closeable {
    private final CRaSHSession session;
    private final ShellProcessContext processContext;
    private final ChunkAdapter adapter;
    private boolean useAlternateBuffer;

    CRaSHProcessContext(CRaSHSession session, final ShellProcessContext processContext) {
        final ChunkBuffer buffer = new ChunkBuffer(new Consumer<Chunk>(){

            @Override
            public void provide(Chunk element) throws IOException {
                processContext.write(element);
            }

            @Override
            public Class<Chunk> getConsumedType() {
                return Chunk.class;
            }

            @Override
            public void flush() throws IOException {
                processContext.flush();
            }
        });
        ChunkAdapter adapter = new ChunkAdapter(new ScreenContext(){

            @Override
            public int getWidth() {
                return processContext.getWidth();
            }

            @Override
            public int getHeight() {
                return processContext.getHeight();
            }

            @Override
            public void write(Chunk chunk) throws IOException {
                this.provide(chunk);
            }

            public Class<Chunk> getConsumedType() {
                return Chunk.class;
            }

            public void provide(Chunk element) throws IOException {
                buffer.provide(element);
            }

            @Override
            public void flush() throws IOException {
                buffer.flush();
            }
        });
        this.session = session;
        this.processContext = processContext;
        this.adapter = adapter;
        this.useAlternateBuffer = false;
    }

    @Override
    public boolean isPiped() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        this.useAlternateBuffer = this.processContext.takeAlternateBuffer();
        return this.useAlternateBuffer;
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        this.useAlternateBuffer = this.processContext.releaseAlternateBuffer();
        return this.useAlternateBuffer;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.processContext.getProperty(propertyName);
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.processContext.readLine(msg, echo);
    }

    @Override
    public int getWidth() {
        return this.adapter.getWidth();
    }

    @Override
    public int getHeight() {
        return this.adapter.getHeight();
    }

    @Override
    public Class<Object> getConsumedType() {
        return Object.class;
    }

    @Override
    public void write(Chunk chunk) throws IOException {
        this.adapter.provide(chunk);
    }

    @Override
    public void provide(Object element) throws IOException {
        this.adapter.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.adapter.flush();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.session;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.session.crash.getContext().getAttributes();
    }

    @Override
    public void close() throws IOException {
        if (this.useAlternateBuffer) {
            this.releaseAlternateBuffer();
        }
    }
}

