/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.doc;

import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.command.CRaSHCommand;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.ShellCommand;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.ResourceKind;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.shell.impl.command.CRaSH;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;

public class Generator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File root = new File(args[0]);
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new AssertionError((Object)("Could not create root directory " + root.getCanonicalPath()));
            }
        } else if (!root.isDirectory()) {
            throw new IllegalArgumentException("Wrong root directory argument " + root.getCanonicalPath());
        }
        FS cmdFS = new FS().mount(Thread.currentThread().getContextClassLoader(), Path.get((String)"/crash/commands/"));
        FS confFS = new FS().mount(Thread.currentThread().getContextClassLoader(), Path.get((String)"/crash/"));
        PluginContext ctx = new PluginContext((PluginDiscovery)new ServiceLoaderDiscovery(Thread.currentThread().getContextClassLoader()), Collections.emptyMap(), cmdFS, confFS, Thread.currentThread().getContextClassLoader());
        ctx.refresh();
        CRaSH crash = new CRaSH(ctx);
        for (String s : ctx.listResourceId(ResourceKind.COMMAND)) {
            File f;
            ShellCommand cmd = crash.getCommand(s);
            StringBuilder man = new StringBuilder();
            if (cmd instanceof CRaSHCommand) {
                CRaSHCommand cc = (CRaSHCommand)cmd;
                ClassDescriptor desc = cc.getDescriptor();
                if (desc.getSubordinates().size() > 1) {
                    for (CommandDescriptor m : desc.getSubordinates().values()) {
                        man.append("{{screen}}");
                        m.printMan((Appendable)man);
                        man.append("{{/screen}}");
                    }
                } else {
                    man.append("{{screen}}");
                    desc.printMan((Appendable)man);
                    man.append("{{/screen}}");
                }
            } else {
                man.append(cmd.describe(s, DescriptionFormat.MAN));
            }
            if (man.length() <= 0 || (f = new File(root, s + ".wiki")).exists()) continue;
            PrintWriter pw = new PrintWriter(f);
            try {
                System.out.println("Generating wiki file " + f.getCanonicalPath());
                pw.print(man);
            }
            finally {
                pw.close();
            }
        }
    }
}

