/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PropertyType {
    PATH(8){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getString();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof String) {
                return factory.createValue((String)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Collections.emptySet();
        }
    }
    ,
    STRING(1){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getString();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof String) {
                return factory.createValue((String)value);
            }
            if (value instanceof Character) {
                return factory.createValue(Character.toString(((Character)value).charValue()));
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(String.class, Character.class);
        }
    }
    ,
    LONG(3){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getLong();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof Long) {
                return factory.createValue(((Long)value).longValue());
            }
            if (value instanceof Integer) {
                return factory.createValue((long)((Integer)value).intValue());
            }
            if (value instanceof Byte) {
                return factory.createValue((long)((Byte)value).byteValue());
            }
            if (value instanceof BigInteger) {
                BigInteger biValue = (BigInteger)value;
                return factory.createValue(biValue.longValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Long.class, Integer.class, Byte.class, BigInteger.class);
        }
    }
    ,
    DOUBLE(4){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getDouble();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof Double) {
                return factory.createValue(((Double)value).doubleValue());
            }
            if (value instanceof Float) {
                return factory.createValue((double)((Float)value).floatValue());
            }
            if (value instanceof BigDecimal) {
                BigDecimal bdValue = (BigDecimal)value;
                return factory.createValue(bdValue.doubleValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Double.class, Float.class, BigDecimal.class);
        }
    }
    ,
    BOOLEAN(6){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getBoolean();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof Boolean) {
                return factory.createValue(((Boolean)value).booleanValue());
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Boolean.class);
        }
    }
    ,
    DATE(5){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getDate();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof Calendar) {
                return factory.createValue((Calendar)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Calendar.class);
        }
    }
    ,
    BINARY(2){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            return value.getStream();
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) {
            if (value instanceof InputStream) {
                return factory.createValue((InputStream)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(InputStream.class);
        }
    }
    ,
    REFERENCE(9){

        @Override
        public Object unwrap(Value value) throws RepositoryException {
            throw new AssertionError((Object)"It should not be called");
        }

        @Override
        protected Value wrap(ValueFactory factory, Object value) throws RepositoryException {
            if (value instanceof Node) {
                return factory.createValue((Node)value);
            }
            return null;
        }

        @Override
        protected Collection<Class<?>> getCanonicalTypes() {
            return Arrays.asList(Node.class);
        }
    };

    private static final PropertyType[] all;
    private static final Map<Class<?>, PropertyType> canonicalMapping;
    private final int value;

    public static PropertyType fromCanonicalType(Class<?> canonicalType) {
        for (Class<?> currentType = canonicalType; currentType != null; currentType = currentType.getSuperclass()) {
            PropertyType type = canonicalMapping.get(currentType);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public static PropertyType fromValue(int v) {
        PropertyType type = null;
        if (v >= 0 && v < all.length) {
            type = all[v];
        }
        if (type == null) {
            throw new IllegalArgumentException("JCR Property type " + v + " not handled yet");
        }
        return type;
    }

    private PropertyType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public Object get(Property property) throws RepositoryException {
        Value[] values;
        if (this == REFERENCE) {
            return property.getNode();
        }
        Value value = property.getDefinition().isMultiple() ? ((values = property.getValues()).length > 0 ? values[0] : null) : property.getValue();
        return value != null ? this.unwrap(value) : null;
    }

    public final Property set(Node node, String name, Object value) throws RepositoryException {
        Value v = this.wrap(node.getSession().getValueFactory(), value);
        if (v != null) {
            try {
                return node.setProperty(name, v);
            }
            catch (ValueFormatException e) {
                return node.setProperty(name, new Value[]{v});
            }
        }
        return null;
    }

    protected abstract Object unwrap(Value var1) throws RepositoryException;

    protected abstract Value wrap(ValueFactory var1, Object var2) throws RepositoryException;

    protected abstract Collection<Class<?>> getCanonicalTypes();

    static {
        all = new PropertyType[20];
        canonicalMapping = new HashMap();
        PropertyType[] arr$ = PropertyType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            PropertyType type;
            PropertyType.all[type.value] = type = arr$[i$];
            for (Class<?> canonicalType : type.getCanonicalTypes()) {
                canonicalMapping.put(canonicalType, type);
            }
        }
    }
}

