/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import org.apache.sshd.server.Command;
import org.crsh.cli.CLIException;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.invocation.Resolver;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.jcr.SinkCommand;
import org.crsh.jcr.SourceCommand;
import org.crsh.ssh.term.FailCommand;
import org.crsh.ssh.term.scp.CommandPlugin;
import org.crsh.ssh.term.scp.SCPAction;

public class SCPCommandPlugin
extends CommandPlugin {
    public Command createCommand(String command) {
        if (command.startsWith("scp ")) {
            try {
                command = command.substring(4);
                SCPAction action = new SCPAction();
                CommandDescriptorImpl descriptor = CommandFactory.DEFAULT.create(SCPAction.class);
                InvocationMatcher analyzer = descriptor.invoker("main");
                InvocationMatch match = analyzer.match(command);
                match.invoke(Resolver.EMPTY, (Object)action);
                if (Boolean.TRUE.equals(action.isSource())) {
                    return new SourceCommand(action.getTarget(), Boolean.TRUE.equals(action.isRecursive()));
                }
                if (Boolean.TRUE.equals(action.isSink())) {
                    return new SinkCommand(action.getTarget(), Boolean.TRUE.equals(action.isRecursive()));
                }
                return new FailCommand("Cannot execute command " + command);
            }
            catch (CLIException e) {
                return new FailCommand("Cannot execute command " + command, (Throwable)e);
            }
        }
        return new FailCommand("Cannot execute command " + command);
    }
}

