/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.command;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.crsh.cli.completers.AbstractPathCompleter;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;
import org.crsh.command.CRaSHCommand;
import org.crsh.jcr.command.Path;

public abstract class JCRCommand
extends CRaSHCommand
implements Completer {
    protected JCRCommand() throws IntrospectionException {
    }

    public Completion complete(ParameterDescriptor parameter, String prefix) throws Exception {
        if (parameter.getDeclaredType() == Path.class) {
            final Path path = (Path)this.getProperty("currentPath");
            final Session session = (Session)this.getProperty("session");
            if (session != null) {
                AbstractPathCompleter<Node> pc = new AbstractPathCompleter<Node>(){

                    protected String getCurrentPath() throws Exception {
                        return path != null ? path.getValue() : "/";
                    }

                    protected Node getPath(String path2) throws Exception {
                        try {
                            return (Node)session.getItem(path2);
                        }
                        catch (RepositoryException e) {
                            return null;
                        }
                    }

                    protected boolean exists(Node path2) throws Exception {
                        return path2 != null;
                    }

                    protected boolean isDirectory(Node path2) throws Exception {
                        return true;
                    }

                    protected boolean isFile(Node path2) throws Exception {
                        return false;
                    }

                    protected Collection<Node> getChilren(Node path2) throws Exception {
                        ArrayList<Node> children = new ArrayList<Node>();
                        NodeIterator i = path2.getNodes();
                        while (i.hasNext()) {
                            Node child = i.nextNode();
                            children.add(child);
                        }
                        return children;
                    }

                    protected String getName(Node path2) throws Exception {
                        return path2.getName();
                    }
                };
                return pc.complete(parameter, prefix);
            }
        }
        return Completion.create();
    }
}

