/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import javax.jcr.Node;
import javax.jcr.Session;
import org.crsh.jcr.AbstractJCRCommandTestCase;

public class ShellTestCase
extends AbstractJCRCommandTestCase {
    public void testCommit() throws Exception {
        this.assertLogin();
        ShellTestCase.assertFalse((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        this.groovyShell.evaluate("session.rootNode.addNode('added_node');");
        ShellTestCase.assertTrue((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        this.assertOk("commit");
        ShellTestCase.assertFalse((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        ShellTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('added_node')"));
    }

    public void testRollback() throws Exception {
        this.assertLogin();
        ShellTestCase.assertFalse((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        ShellTestCase.assertTrue((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        this.assertOk("rollback");
        ShellTestCase.assertFalse((boolean)((Session)this.shell.get((Object)"session")).hasPendingChanges());
        ShellTestCase.assertEquals((Object)false, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('foo')"));
    }

    public void testExportImport() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo', 'nt:folder');");
        this.assertOk("node export /foo /foo.xml");
        Node fooXML = (Node)this.groovyShell.evaluate("node = session.rootNode['foo.xml']");
        ShellTestCase.assertNotNull((Object)fooXML);
        ShellTestCase.assertEquals((String)"nt:file", (String)fooXML.getPrimaryNodeType().getName());
        Node fooContent = fooXML.getNode("jcr:content");
        ShellTestCase.assertEquals((String)"application/xml", (String)fooContent.getProperty("jcr:mimeType").getString());
        this.groovyShell.evaluate("session.rootNode.foo.remove()");
        this.assertOk("node import /foo.xml /");
        Node foo = (Node)this.groovyShell.evaluate("return session.rootNode.foo");
        ShellTestCase.assertNotNull((Object)foo);
        ShellTestCase.assertEquals((String)"foo", (String)foo.getName());
    }

    public void testPWD() throws Exception {
    }

    public void testPipe() throws Exception {
        this.assertLogin();
        this.assertOk("node add foo | node add bar");
        ShellTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
        ShellTestCase.assertTrue((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('bar');")));
    }

    public void testPipe2() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo').setProperty('bar','juu');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("select * from nt:base where bar = 'juu' | rm");
        ShellTestCase.assertFalse((boolean)((Boolean)this.groovyShell.evaluate("return session.rootNode.hasNode('foo');")));
    }

    public void testDistribution() throws Exception {
        this.assertLogin();
        String produced = this.assertOk("produce / | node set foo foo_value | node set bar bar_value | consume");
        ShellTestCase.assertEquals((String)"/\n", (String)produced);
        ShellTestCase.assertEquals((Object)"foo_value", (Object)this.groovyShell.evaluate("return session.rootNode.getProperty('foo').string;"));
        ShellTestCase.assertEquals((Object)"bar_value", (Object)this.groovyShell.evaluate("return session.rootNode.getProperty('bar').string;"));
    }
}

