/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import javax.jcr.Repository;

public abstract class RepositoryProvider {
    private static RepositoryProvider provider;
    private static boolean initialized;

    public static synchronized RepositoryProvider getProvider() throws Exception {
        if (!initialized) {
            Iterator<RepositoryProvider> it = ServiceLoader.load(RepositoryProvider.class).iterator();
            if (it.hasNext()) {
                RepositoryProvider repoBoostrap = it.next();
                repoBoostrap.bootstrap();
                provider = repoBoostrap;
                initialized = true;
            } else {
                throw new NoSuchElementException("No repository available");
            }
        }
        return provider;
    }

    protected abstract void bootstrap() throws Exception;

    public abstract Repository getRepository();

    public abstract String getLogin() throws Exception;

    public abstract void logout() throws Exception;
}

