/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.shell;

import org.crsh.jcr.shell.AbstractJCRCommandTestCase;

public class CopyTestCase
extends AbstractJCRCommandTestCase {
    public void testCopyRelativeToRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo bar");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('bar')"));
    }

    public void testCopyToExisting() {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo bar");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('bar[2]')"));
    }

    public void testSubRelativeToSubRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('foo2');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo/foo2 foo/foo3");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('foo').hasNode('foo3')"));
    }

    public void testAbsoluteToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp /foo/bar /zed");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('zed')"));
    }

    public void testRelativeToSubRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')"));
    }

    public void testAbsoluteToRelative() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp /foo bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')"));
    }

    public void testRelativeToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo /bar/zed");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.getNode('bar').hasNode('zed')"));
    }

    public void testSubRelativeToAbsolute() throws Exception {
        this.assertLogin();
        this.groovyShell.evaluate("session.rootNode.addNode('foo');");
        this.groovyShell.evaluate("session.rootNode.getNode('foo').addNode('bar');");
        this.groovyShell.evaluate("session.save();");
        this.assertOk("cp foo/bar /zed");
        this.groovyShell.evaluate("session.refresh(true);");
        CopyTestCase.assertEquals((Object)true, (Object)this.groovyShell.evaluate("return session.rootNode.hasNode('zed')"));
    }
}

