/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr.command;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.spi.Completer;
import org.crsh.command.CRaSHCommand;
import org.crsh.jcr.command.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRCommand
extends CRaSHCommand
implements Completer {
    protected JCRCommand() throws IntrospectionException {
    }

    public Map<String, Boolean> complete(ParameterDescriptor<?> parameter, String prefix) throws Exception {
        if (parameter.getJavaValueType() == Path.class) {
            Path path = (Path)((Object)this.getProperty("currentPath"));
            Session session = (Session)this.getProperty("session");
            if (session != null) {
                Node relative = null;
                if (prefix.length() == 0 || prefix.charAt(0) != '/') {
                    Item item;
                    if (path != null && (item = session.getItem(path.getString())) instanceof Node) {
                        relative = (Node)item;
                    }
                } else {
                    relative = session.getRootNode();
                    prefix = prefix.substring(1);
                }
                if (relative != null) {
                    int index = prefix.indexOf(47);
                    while (index != -1) {
                        String name = prefix.substring(0, index);
                        if (!relative.hasNode(name)) {
                            return Collections.emptyMap();
                        }
                        relative = relative.getNode(name);
                        prefix = prefix.substring(index + 1);
                        index = prefix.indexOf(47);
                    }
                }
                HashMap<String, Boolean> completions = new HashMap<String, Boolean>();
                NodeIterator i = relative.getNodes(prefix + '*');
                while (i.hasNext()) {
                    Node child = i.nextNode();
                    String suffix = child.getName().substring(prefix.length());
                    if (child.hasNodes()) {
                        completions.put(suffix + '/', false);
                        continue;
                    }
                    completions.put(suffix, true);
                }
                return completions;
            }
        }
        return Collections.emptyMap();
    }
}

