/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.crsh.jcr.FileSystem;
import org.crsh.util.XML;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Exporter
extends DefaultHandler {
    private final Map<String, String> mappings = new HashMap<String, String>();
    private FileSystem fs;

    public Exporter(FileSystem fs) {
        this.fs = fs;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mappings.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.mappings.remove(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String fileName = XML.fileName((String)qName);
            this.fs.startDirectory(fileName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(out);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(streamResult);
            hd.startDocument();
            for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
                String prefix = mapping.getKey();
                hd.startPrefixMapping(prefix, mapping.getValue());
            }
            hd.startElement(uri, localName, qName, attributes);
            hd.endElement(uri, localName, qName);
            for (String prefix : this.mappings.keySet()) {
                hd.endPrefixMapping(prefix);
            }
            hd.endDocument();
            out.close();
            byte[] content = out.toByteArray();
            this.fs.file("crash__content.xml", content.length, new ByteArrayInputStream(content));
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            String fileName = XML.fileName((String)qName);
            this.fs.endDirectory(fileName);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

