/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.mail;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import junit.framework.Assert;
import org.crsh.TestPluginLifeCycle;
import org.crsh.mail.MailPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListenerAdapter;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class Support {
    protected SMTPServer createServer(MessageHandlerFactory mhf) {
        return new SMTPServer(mhf);
    }

    protected TestPluginLifeCycle createLifeCycle() throws Exception {
        TestPluginLifeCycle test = new TestPluginLifeCycle(new CRaSHPlugin[]{new MailPlugin()});
        test.setProperty(MailPlugin.SMTP_HOST, (Object)"localhost");
        test.setProperty(MailPlugin.SMTP_PORT, (Object)5000);
        test.setProperty(MailPlugin.SMTP_FROM, (Object)"foo@gmail.com");
        return test;
    }

    protected Future<Boolean> send(MailPlugin plugin) throws IOException, MessagingException {
        return plugin.send(Arrays.asList("dst@gmail.com"), "Testing Subject", "Dear Mail Crawler,\n\n No spam to my email, please!", new DataSource[0]);
    }

    protected void assertResponse(Wiser wiser, Future<Boolean> response) throws MessagingException, ExecutionException, InterruptedException {
        Assert.assertTrue((boolean)response.get());
        Assert.assertEquals((int)1, (int)wiser.getMessages().size());
        WiserMessage msg = (WiserMessage)wiser.getMessages().get(0);
        this.assertMessage(msg);
    }

    protected void assertMessage(WiserMessage msg) throws MessagingException {
        Assert.assertEquals((String)"foo@gmail.com", (String)msg.getEnvelopeSender());
        Assert.assertEquals((String)"dst@gmail.com", (String)msg.getEnvelopeReceiver());
        Assert.assertEquals((String)"Testing Subject", (String)msg.getMimeMessage().getSubject());
    }

    protected void execute(TestPluginLifeCycle lifeCycle, Wiser wiser) throws IOException, MessagingException, ExecutionException, InterruptedException {
        MailPlugin plugin = (MailPlugin)lifeCycle.getContext().getPlugin(MailPlugin.class);
        Future<Boolean> future = this.send(plugin);
        this.assertResponse(wiser, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest() throws Exception {
        Wiser wiser = new Wiser();
        SMTPServer smtpServer = this.createServer((MessageHandlerFactory)new SimpleMessageListenerAdapter((SimpleMessageListener)wiser));
        smtpServer.setHostName("localhost");
        smtpServer.setPort(5000);
        TestPluginLifeCycle lifeCycle = this.createLifeCycle();
        try {
            lifeCycle.start();
            smtpServer.start();
            this.execute(lifeCycle, wiser);
        }
        finally {
            smtpServer.stop();
            lifeCycle.stop();
        }
    }
}

