/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.util.concurrent.Executors;
import junit.framework.TestCase;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.connector.Connector;
import org.crsh.term.TermAction;
import org.crsh.term.TermShellAdapter;
import org.crsh.term.TermStatus;
import org.crsh.term.TestShell;
import org.crsh.term.TestShellAction;
import org.crsh.term.TestTerm;
import org.crsh.term.processor.TermProcessor;

public class TermShellAdapterTestCase
extends TestCase {
    public void testReadLine() throws Exception {
        this.testReadLine(true);
    }

    public void testReadLineNoExecutor() throws Exception {
        this.testReadLine(false);
    }

    private void testReadLine(boolean withExecutor) throws Exception {
        TestShell shell = new TestShell();
        Connector connector = withExecutor ? new Connector(Executors.newSingleThreadExecutor(), (Shell)shell) : new Connector((Shell)shell);
        TermShellAdapter adapter = new TermShellAdapter(connector);
        connector.open();
        TestTerm term = new TestTerm((TermProcessor)adapter);
        TermShellAdapterTestCase.assertEquals((Object)TermStatus.READY, (Object)adapter.getStatus());
        System.out.println("1");
        term.add((TermAction)new TermAction.ReadLine((CharSequence)"foo"));
        System.out.println("2");
        shell.append(new TestShellAction(){

            public ShellResponse evaluate(String request, ShellResponseContext responseContext) throws Exception {
                String resp = responseContext.readLine("bar", true);
                return new ShellResponse.Display(resp);
            }
        });
        while (adapter.getStatus() != TermStatus.READING_INPUT) {
            Thread.sleep(10L);
        }
        System.out.println("3");
        term.add((TermAction)new TermAction.ReadLine((CharSequence)"juu"));
        while (adapter.getStatus() != TermStatus.READY) {
            Thread.sleep(10L);
        }
        System.out.println("ABC");
        term.add((TermAction)new TermAction.ReadLine((CharSequence)"bye"));
    }
}

