/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.io.Writer;
import org.crsh.command.CommandContext;
import org.crsh.command.Description;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.shell.io.ShellPrinter;
import org.crsh.util.TypeResolver;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCommand<C, P>
extends GroovyObjectSupport
implements ShellCommand<C, P> {
    private CommandContext<C, P> context = null;
    private boolean unquoteArguments = true;
    private Class<C> consumedType = (Class)TypeResolver.resolve(this.getClass(), ShellCommand.class, 0);
    private Class<P> producedType = (Class)TypeResolver.resolve(this.getClass(), ShellCommand.class, 1);

    protected BaseCommand() {
    }

    @Override
    public Class<P> getProducedType() {
        return this.producedType;
    }

    @Override
    public Class<C> getConsumedType() {
        return this.consumedType;
    }

    public final Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            Object o = this.context.getAttributes().get(name);
            if (o instanceof Closure) {
                Closure closure = (Closure)o;
                if (args instanceof Object[]) {
                    Object[] array = (Object[])args;
                    if (array.length == 0) {
                        return closure.call();
                    }
                    return closure.call(array);
                }
                return closure.call(args);
            }
            throw e;
        }
    }

    public final Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.context.getAttributes().get(property);
        }
    }

    public final void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.context.getAttributes().put(property, newValue);
        }
    }

    protected boolean getUnquoteArguments() {
        return this.unquoteArguments;
    }

    public void setUnquoteArguments(boolean unquoteArguments) {
        this.unquoteArguments = unquoteArguments;
    }

    protected final String readLine(String msg) {
        return this.readLine(msg, true);
    }

    protected final String readLine(String msg, boolean echo) {
        if (this.context == null) {
            throw new IllegalStateException("No current context");
        }
        return this.context.readLine(msg, echo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(CommandContext<C, P> context, String ... args) throws ScriptException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (args == null) {
            throw new NullPointerException();
        }
        CmdLineParser parser = new CmdLineParser((Object)this);
        if (args.length > 0 && ("-h".equals(args[0]) || "--help".equals(args[0]))) {
            ShellPrinter out = context.getWriter();
            Description description = this.getClass().getAnnotation(Description.class);
            if (description != null) {
                out.write(description.value());
                out.write("\n");
            }
            parser.printUsage((Writer)out, null);
        } else {
            if (this.unquoteArguments) {
                String[] foo = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.charAt(0) == '\'') {
                        if (arg.charAt(arg.length() - 1) == '\'') {
                            arg = arg.substring(1, arg.length() - 1);
                        }
                    } else if (arg.charAt(0) == '\"' && arg.charAt(arg.length() - 1) == '\"') {
                        arg = arg.substring(1, arg.length() - 1);
                    }
                    foo[i] = arg;
                }
                args = foo;
            }
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                throw new ScriptException(e.getMessage(), e);
            }
            try {
                this.context = context;
                this.execute(context);
            }
            finally {
                this.context = null;
            }
        }
    }

    protected abstract void execute(CommandContext<C, P> var1) throws ScriptException;
}

