/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.servlet.ServletShellContext;
import org.crsh.term.spi.sshd.SSHLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHServletLifeCycle
implements ServletContextListener {
    private final Logger log = LoggerFactory.getLogger(SSHServletLifeCycle.class);
    private SSHLifeCycle lifeCycle;
    private ServletShellContext shellContext;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        int port = Integer.parseInt(sc.getInitParameter("ssh.port").trim());
        String keyPath = sc.getInitParameter("ssh.keypath");
        if (keyPath == null) {
            this.log.debug("No key path found in web.xml will use the default one");
            keyPath = sc.getRealPath("/WEB-INF/sshd/hostkey.pem");
            this.log.debug("Going to use the key path at " + keyPath);
        }
        ServletShellContext shellContext = new ServletShellContext(sc, Thread.currentThread().getContextClassLoader());
        SSHLifeCycle lifeCycle = new SSHLifeCycle(shellContext);
        lifeCycle.setKeyPath(keyPath);
        lifeCycle.setPort(port);
        this.lifeCycle = lifeCycle;
        this.shellContext = shellContext;
        lifeCycle.init();
        shellContext.start();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
        }
        if (this.shellContext != null) {
            this.shellContext.stop();
        }
    }
}

