/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.crsh.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private final String content;
    private long timestamp;

    public static Resource create(URL url) {
        try {
            URLConnection conn = url.openConnection();
            long timestamp = conn.getLastModified();
            InputStream in = url.openStream();
            String content = IO.readAsUTF8(in);
            return new Resource(content, timestamp);
        }
        catch (IOException e) {
            log.warn("Could not obtain resource " + url, (Throwable)e);
            return null;
        }
    }

    public Resource(String content, long timestamp) {
        this.content = content;
        this.timestamp = timestamp;
    }

    public String getContent() {
        return this.content;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

