/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import org.crsh.command.SyntaxException;
import org.crsh.shell.impl.AST;
import org.crsh.shell.impl.Token;
import org.crsh.shell.impl.Tokenizer;

class Parser {
    private Tokenizer tokenizer;
    private Token token;

    public Parser(CharSequence s) {
        this.tokenizer = new Tokenizer(s);
        this.token = this.tokenizer.nextToken();
    }

    public AST parse() {
        if (this.token == Token.EOF) {
            return null;
        }
        return this.parseExpr();
    }

    private AST.Expr parseExpr() {
        AST.Term term = this.parseTerm();
        if (this.token == Token.EOF) {
            return new AST.Expr(term);
        }
        if (this.token == Token.PIPE) {
            this.token = this.tokenizer.nextToken();
            AST.Expr next = this.parseExpr();
            return new AST.Expr(term, next);
        }
        throw new SyntaxException("Syntax error");
    }

    private AST.Term parseTerm() {
        if (this.token instanceof Token.Command) {
            Token.Command command = (Token.Command)this.token;
            this.token = this.tokenizer.nextToken();
            if (this.token == Token.PLUS) {
                this.token = this.tokenizer.nextToken();
                AST.Term next = this.parseTerm();
                return new AST.Term(command.chunks, next);
            }
            return new AST.Term(command.chunks);
        }
        throw new SyntaxException("Syntax error");
    }
}

