/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IllegalParameterException;
import org.crsh.cmdline.IllegalValueTypeException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.SimpleValueType;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionDescriptor<B extends TypeBinding>
extends ParameterDescriptor<B> {
    private final int arity;
    private final List<String> names;

    public OptionDescriptor(B binding, Type javaType, List<String> names, Description info, boolean required, int arity, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        super(binding, javaType, info, required, password, unquote, completerType, annotation);
        if (arity > 1 && this.getMultiplicity() == Multiplicity.ZERO_OR_ONE) {
            throw new IllegalParameterException();
        }
        if (this.getMultiplicity() == Multiplicity.ZERO_OR_MORE && this.getType() == SimpleValueType.BOOLEAN) {
            throw new IllegalParameterException();
        }
        names = new ArrayList<String>(names);
        for (String name : names) {
            if (name.length() == 0) {
                throw new IllegalParameterException("Option name cannot be empty");
            }
            if (name == null) {
                throw new IllegalParameterException("Option name must not be null");
            }
            if (!name.contains("-")) continue;
            throw new IllegalParameterException("Option name must not contain the hyphen character");
        }
        if (this.getType() == SimpleValueType.BOOLEAN && arity < 1) {
            arity = 0;
        } else if (arity == -1) {
            arity = 1;
        }
        this.arity = arity;
        this.names = Collections.unmodifiableList(names);
    }

    public int getArity() {
        return this.arity;
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        writer.append("[");
        boolean a = false;
        for (String optionName : this.names) {
            if (a) {
                writer.append(" | ");
            }
            writer.append(optionName.length() == 1 ? "-" : "--").append(optionName);
            a = true;
        }
        writer.append("]");
    }

    public String toString() {
        return "OptionDescriptor[" + this.names + "]";
    }
}

