/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.display.structure;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.crsh.display.DisplayContext;
import org.crsh.display.structure.Element;

public class TreeElement
extends Element {
    private Element value;
    private List<Element> nodes = new ArrayList<Element>();

    public TreeElement() {
        this(null);
    }

    public TreeElement(Element value) {
        this.value = value;
    }

    public TreeElement addNode(Element node) {
        this.nodes.add(node);
        return this;
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Element getValue() {
        return this.value;
    }

    public Element getNode(int index) {
        return this.nodes.get(index);
    }

    public void print(PrintWriter printer) {
        if (this.value != null) {
            this.value.print(printer);
            printer.println();
        }
        DisplayContextImpl nodeContext = new DisplayContextImpl(printer);
        for (Element node : this.nodes) {
            node.print(nodeContext);
            nodeContext.printer().println();
            nodeContext.first = true;
        }
    }

    private static class DisplayContextImpl
    extends DisplayContext {
        private static final char[] firstRow = "+-".toCharArray();
        private static final char[] otherRow = "| ".toCharArray();
        private final PrintWriter parent;
        private boolean first = true;
        private boolean padded = false;

        private DisplayContextImpl(PrintWriter parent) {
            this.parent = parent;
        }

        private void pad() {
            if (!this.padded) {
                if (this.first) {
                    this.parent.write(firstRow, 0, 2);
                    this.first = false;
                } else {
                    this.parent.write(otherRow, 0, 2);
                }
                this.padded = true;
            }
        }

        protected void print(char[] cbuf, int off, int len) {
            this.pad();
            this.parent.write(cbuf, off, len);
        }

        protected void println() {
            if (this.padded) {
                this.parent.println();
                this.padded = false;
            }
        }
    }
}

