/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.term.console.ConsoleReader;
import org.crsh.term.console.ConsoleWriter;
import org.crsh.term.console.ViewReader;
import org.crsh.term.console.ViewWriter;

public final class Console {
    private char[] buffer;
    private int size = 0;
    private int curAt = 0;
    private LinkedList<CharSequence> lines;
    private boolean previousCR = false;
    private boolean echoing = true;
    private final ViewWriter viewWriter;
    private final ViewReader viewReader = new ViewReader(){

        public CharSequence replace(CharSequence s) throws IOException {
            StringBuilder builder = new StringBuilder();
            int i = Console.this.appendDel();
            while (i != -1) {
                builder.append((char)i);
                i = Console.this.appendDel();
            }
            Console.this.appendData(s);
            return builder.reverse().toString();
        }

        public void write(char c) throws IOException {
            Console.this.appendData(c);
        }

        public void write(CharSequence s) throws IOException {
            Console.this.appendData(((Object)s).toString());
        }

        public void del() throws IOException {
            Console.this.appendDel();
        }

        public void moveRight() throws IOException {
            Console.this.moveRight();
        }

        public void moveLeft() throws IOException {
            Console.this.moveLeft();
        }
    };
    private final ConsoleReader reader = new ConsoleReader(){

        public int getSize() {
            return Console.this.size;
        }

        public boolean hasNext() {
            return Console.this.lines.size() > 0;
        }

        public CharSequence next() {
            if (Console.this.lines.size() > 0) {
                return (CharSequence)Console.this.lines.removeFirst();
            }
            throw new NoSuchElementException();
        }
    };
    private final ConsoleWriter writer = new ConsoleWriter(){
        private boolean previousCR;

        public void write(CharSequence s) throws IOException {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                this.writeNoFlush(c);
            }
            Console.this.viewWriter.flush();
        }

        public void write(char c) throws IOException {
            this.writeNoFlush(c);
            Console.this.viewWriter.flush();
        }

        private void writeNoFlush(char c) throws IOException {
            if (this.previousCR && c == '\n') {
                this.previousCR = false;
            } else if (c == '\r' || c == '\n') {
                this.previousCR = c == '\r';
                Console.this.viewWriter.writeCRLF();
            } else {
                Console.this.viewWriter.write(c);
            }
        }
    };

    public Console(ViewWriter viewWriter) {
        this.buffer = new char[128];
        this.lines = new LinkedList();
        this.viewWriter = viewWriter;
    }

    public void clearBuffer() {
        this.previousCR = false;
        this.curAt = 0;
        this.size = 0;
    }

    public CharSequence getBuffer() {
        return new String(this.buffer, 0, this.size);
    }

    public CharSequence getBufferToCursor() {
        return new String(this.buffer, 0, this.curAt);
    }

    public boolean isEchoing() {
        return this.echoing;
    }

    public void setEchoing(boolean echoing) {
        this.echoing = echoing;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public ViewReader getViewReader() {
        return this.viewReader;
    }

    public ConsoleWriter getWriter() {
        return this.writer;
    }

    private void appendData(CharSequence s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.appendData(s.charAt(i));
        }
    }

    private void appendData(char c) throws IOException {
        if (this.previousCR && c == '\n') {
            this.previousCR = false;
        } else if (c == '\r' || c == '\n') {
            this.previousCR = c == '\r';
            String line = new String(this.buffer, 0, this.size);
            this.lines.add(line);
            this.curAt = this.size = 0;
            this.echoCRLF();
        } else {
            this.push(c);
        }
    }

    private int appendDel() throws IOException {
        if (this.curAt == this.size) {
            int popped = this.pop();
            if (popped != -1) {
                this.echoDel();
            }
            return popped;
        }
        if (this.curAt == 0) {
            return -1;
        }
        for (int idx = this.curAt - 1; idx < this.size; ++idx) {
            this.buffer[idx] = this.buffer[idx + 1];
        }
        this.buffer[this.size - 1] = 32;
        --this.size;
        this.moveLeft();
        String disp = new String(this.buffer, this.curAt, this.size - this.curAt + 1);
        this.viewWriter.write(disp);
        int saveCurAt = this.curAt;
        this.curAt = this.size + 1;
        while (this.curAt > saveCurAt) {
            this.moveLeft();
        }
        if (this.curAt == 0) {
            return -1;
        }
        return this.buffer[this.curAt - 1];
    }

    private void moveRight() throws IOException {
        if (this.curAt < this.size && this.viewWriter.writeMoveRight(this.buffer[this.curAt])) {
            this.viewWriter.flush();
            ++this.curAt;
        }
    }

    private void moveLeft() throws IOException {
        if (this.curAt > 0 && this.viewWriter.writeMoveLeft()) {
            this.viewWriter.flush();
            --this.curAt;
        }
    }

    private void echo(char c) throws IOException {
        if (this.echoing) {
            this.viewWriter.write(c);
            this.viewWriter.flush();
        }
    }

    private void echo(String s) throws IOException {
        if (this.echoing) {
            this.viewWriter.write(s);
            this.viewWriter.flush();
        }
    }

    private void echoDel() throws IOException {
        if (this.echoing) {
            this.viewWriter.writeDel();
            this.viewWriter.flush();
        }
    }

    private void echoCRLF() throws IOException {
        if (this.echoing) {
            this.viewWriter.writeCRLF();
            this.viewWriter.flush();
        }
    }

    private int pop() {
        if (this.size > 0) {
            --this.size;
            this.curAt = this.size;
            return this.buffer[this.size];
        }
        this.curAt = this.size;
        return -1;
    }

    private void push(char c) throws IOException {
        if (this.size >= this.buffer.length) {
            char[] tmp = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        if (this.curAt == this.size) {
            this.buffer[this.size++] = c;
            this.curAt = this.size;
            this.echo(c);
        } else {
            for (int idx = this.size - 1; idx > this.curAt - 1; --idx) {
                this.buffer[idx + 1] = this.buffer[idx];
            }
            this.buffer[this.curAt] = c;
            ++this.size;
            String disp = new String(this.buffer, this.curAt, this.size - this.curAt);
            this.viewWriter.write(disp);
            int saveCurAt = ++this.curAt;
            this.curAt = this.size;
            while (this.curAt > saveCurAt) {
                this.moveLeft();
            }
        }
    }
}

