/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.crsh.cmdline.matcher.impl.Termination;
import org.crsh.cmdline.matcher.impl.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tokenizer
implements Iterator<Token> {
    private static final int WORD = 0;
    private static final int SHORT_OPTION = 1;
    private static final int LONG_OPTION = 2;
    private final CharSequence s;
    private int index;
    private ArrayList<Token> stack;
    private int ptr;

    Tokenizer(CharSequence s) {
        this.s = s;
        this.index = 0;
        this.stack = new ArrayList();
        this.ptr = 0;
    }

    @Override
    public Token next() {
        if (this.hasNext()) {
            return this.stack.get(this.ptr++);
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.ptr < this.stack.size()) {
            return true;
        }
        Token next = this.parse();
        if (next != null) {
            this.stack.add(next);
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    int getIndex() {
        Token peek = this.peek();
        if (peek != null) {
            return peek.index;
        }
        return this.index;
    }

    void pushBack() {
        this.pushBack(1);
    }

    void pushBack(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        if (this.ptr - count < 0) {
            throw new IllegalStateException("Trying to push back too many tokens");
        }
        this.ptr -= count;
    }

    Token peek() {
        if (this.hasNext()) {
            return this.stack.get(this.ptr);
        }
        return null;
    }

    private Token parse() {
        Token next = null;
        int mark = this.index;
        while (this.index < this.s.length() && Character.isWhitespace(this.s.charAt(this.index))) {
            ++this.index;
        }
        if (this.index > mark) {
            next = new Token.Whitespace(mark, ((Object)this.s.subSequence(mark, this.index)).toString());
        } else if (this.index < this.s.length()) {
            int type;
            StringBuilder value = new StringBuilder();
            char c = this.s.charAt(this.index);
            if (c == '-') {
                ++this.index;
                value.append('-');
                if (this.index < this.s.length()) {
                    c = this.s.charAt(this.index);
                    if (c == '-') {
                        ++this.index;
                        value.append('-');
                        type = 2;
                    } else {
                        type = 1;
                    }
                } else {
                    type = 1;
                }
            } else {
                type = 0;
            }
            Character lastQuote = null;
            while (this.index < this.s.length()) {
                c = this.s.charAt(this.index);
                if (lastQuote == null) {
                    if (Character.isWhitespace(c)) break;
                    if (c == '\'' || c == '\"') {
                        lastQuote = Character.valueOf(c);
                    } else {
                        value.append(c);
                    }
                    ++this.index;
                    continue;
                }
                ++this.index;
                if (c == lastQuote.charValue()) {
                    lastQuote = null;
                    continue;
                }
                value.append(c);
            }
            Termination termination = lastQuote == null ? Termination.DETERMINED : (lastQuote.charValue() == '\'' ? Termination.SINGLE_QUOTE : Termination.DOUBLE_QUOTE);
            switch (type) {
                case 0: {
                    next = new Token.Literal.Word(mark, ((Object)this.s.subSequence(mark, this.index)).toString(), value.toString(), termination);
                    break;
                }
                case 1: {
                    next = new Token.Literal.Option.Short(mark, ((Object)this.s.subSequence(mark, this.index)).toString(), value.toString(), termination);
                    break;
                }
                case 2: {
                    next = new Token.Literal.Option.Long(mark, ((Object)this.s.subSequence(mark, this.index)).toString(), value.toString(), termination);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return next;
    }
}

