/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.crsh.plugin.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDescriptor<T> {
    private static final Map<String, PropertyDescriptor<?>> INTERNAL_ALL = new HashMap();
    public static final Map<String, PropertyDescriptor<?>> ALL = Collections.unmodifiableMap(INTERNAL_ALL);
    public static final PropertyDescriptor<Integer> SSH_PORT = new PropertyDescriptor<Integer>(Integer.class, "ssh.port", Integer.valueOf(2000), "The SSH port"){

        @Override
        public Integer doParse(String s) {
            return Integer.parseInt(s);
        }
    };
    public static final PropertyDescriptor<String> SSH_KEYPATH = new PropertyDescriptor<String>(String.class, "ssh.keypath", null, "The path to the key file"){

        @Override
        public String doParse(String s) {
            return s;
        }
    };
    public static final PropertyDescriptor<Integer> TELNET_PORT = new PropertyDescriptor<Integer>(Integer.class, "telnet.port", Integer.valueOf(5000), "The telnet port"){

        @Override
        public Integer doParse(String s) {
            return Integer.parseInt(s);
        }
    };
    public static final PropertyDescriptor<TimeUnit> VFS_REFRESH_UNIT = new PropertyDescriptor<TimeUnit>(TimeUnit.class, "vfs.refresh_unit", TimeUnit.SECONDS, "The refresh time unit"){

        @Override
        public TimeUnit doParse(String s) {
            return TimeUnit.valueOf(s);
        }
    };
    public static final PropertyDescriptor<Integer> VFS_REFRESH_PERIOD = new PropertyDescriptor<Integer>(Integer.class, "vfs.refresh_period", null, "The refresh rate period"){

        @Override
        public Integer doParse(String s) {
            return Integer.parseInt(s);
        }
    };
    public final Class<T> type;
    public final String name;
    public final T defaultValue;
    public final String description;

    private PropertyDescriptor(Class<T> type, String name, T defaultValue) {
        this(type, name, defaultValue, null);
    }

    private PropertyDescriptor(Class<T> type, String name, T defaultValue, String description) {
        if (name == null) {
            throw new AssertionError();
        }
        this.type = type;
        this.name = name;
        this.defaultValue = defaultValue;
        this.description = description;
        INTERNAL_ALL.put(name, this);
    }

    public final T parse(String s) throws NullPointerException, IllegalArgumentException {
        if (s == null) {
            throw new NullPointerException("Cannot parse null property values");
        }
        try {
            return this.doParse(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal property value " + s, e);
        }
    }

    public final Property<T> toProperty(String s) throws NullPointerException, IllegalArgumentException {
        T value = this.parse(s);
        return new Property<T>(this, value);
    }

    protected abstract T doParse(String var1);
}

