/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.command.CommandInvoker;
import org.crsh.command.ShellCommand;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSH;
import org.crsh.shell.impl.CreateCommandException;
import org.crsh.shell.impl.InvocationContextImpl;

abstract class AST {
    AST() {
    }

    abstract Term lastTerm();

    static class Term
    extends AST {
        final String line;
        final Term next;
        private ShellCommand command;
        private CommandInvoker invoker;

        Term(String line, Term next) {
            this.line = line;
            this.next = next;
        }

        Term(String line) {
            this.line = line;
            this.next = null;
        }

        private ShellResponse createCommands(CRaSH crash) {
            CommandInvoker<?, ?> invoker = null;
            Pattern p = Pattern.compile("^\\s*(\\S+)");
            Matcher m = p.matcher(this.line);
            String name = null;
            if (m.find()) {
                name = m.group(1);
                try {
                    this.command = crash.getCommand(name);
                    if (this.command != null) {
                        invoker = this.command.createInvoker(this.line.substring(m.end()));
                    }
                }
                catch (CreateCommandException e) {
                    CRaSH.log.error("Could not create command " + name, (Throwable)e);
                    return new ShellResponse.Error(ErrorType.INTERNAL, e);
                }
            }
            if (invoker == null) {
                return new ShellResponse.UnknownCommand(name);
            }
            this.invoker = invoker;
            if (this.next != null) {
                return this.next.createCommands(crash);
            }
            return null;
        }

        String getLine() {
            return this.line;
        }

        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Expr
    extends AST {
        final Term term;
        final Expr next;

        Expr(Term term) {
            this.term = term;
            this.next = null;
        }

        Expr(Term term, Expr next) {
            this.term = term;
            this.next = next;
        }

        ShellResponse createCommands(CRaSH crash) {
            ShellResponse resp = this.term.createCommands(crash);
            if (resp == null && this.next != null) {
                return this.next.createCommands(crash);
            }
            return resp;
        }

        ShellResponse execute(ShellProcessContext responseContext, Map<String, Object> attributes) {
            try {
                return this.execute(responseContext, attributes, null);
            }
            catch (Throwable t) {
                return new ShellResponse.Error(ErrorType.EVALUATION, t);
            }
        }

        private ShellResponse execute(ShellProcessContext responseContext, Map<String, Object> attributes, ArrayList consumed) {
            ArrayList produced = new ArrayList();
            StringBuilder out = new StringBuilder();
            Term current = this.term;
            while (current != null) {
                InvocationContextImpl ctx = current.invoker.getConsumedType() == Void.class ? new InvocationContextImpl(responseContext, null, attributes) : new InvocationContextImpl(responseContext, consumed, attributes);
                current.invoker.invoke(ctx);
                if (ctx.getBuffer() != null) {
                    out.append(ctx.getBuffer().toString());
                }
                if (current.invoker.getProducedType() != Void.class) {
                    produced.addAll(ctx.getProducedItems());
                }
                current = current.next;
            }
            if (this.next != null) {
                return this.next.execute(responseContext, attributes, produced);
            }
            ShellResponse.Ok response = out.length() > 0 ? new ShellResponse.Display(produced, out.toString()) : new ShellResponse.Ok(produced);
            return response;
        }

        @Override
        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            if (this.term != null) {
                return this.term.lastTerm();
            }
            return null;
        }
    }
}

