/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.EmptyCompleter;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.LiteralValue;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.MethodMatch;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.Parser;
import org.crsh.cmdline.matcher.impl.Termination;
import org.crsh.cmdline.matcher.impl.Token;
import org.crsh.cmdline.matcher.impl.Tokenizer;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherImpl<T>
extends Matcher<T> {
    private final ClassDescriptor<T> descriptor;
    private final String mainName;

    public MatcherImpl(ClassDescriptor<T> descriptor) {
        this(null, descriptor);
    }

    public MatcherImpl(String mainName, ClassDescriptor<T> descriptor) {
        this.mainName = mainName;
        this.descriptor = descriptor;
    }

    private List<LiteralValue> bilto(List<? extends Token.Literal> literals) {
        ArrayList<LiteralValue> values = new ArrayList<LiteralValue>(literals.size());
        for (Token.Literal literal : literals) {
            values.add(new LiteralValue(literal.raw, literal.value));
        }
        return values;
    }

    @Override
    public CommandMatch<T, ?, ?> match(String s) {
        Integer classEnd;
        Tokenizer tokenizer = new Tokenizer(s);
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Parser.Mode.INVOKE);
        ArrayList<OptionMatch<ClassFieldBinding>> classOptions = new ArrayList<OptionMatch<ClassFieldBinding>>();
        ArrayList<ArgumentMatch<ClassFieldBinding>> classArguments = new ArrayList<ArgumentMatch<ClassFieldBinding>>();
        ArrayList<OptionMatch<MethodArgumentBinding>> methodOptions = new ArrayList<OptionMatch<MethodArgumentBinding>>();
        ArrayList<ArgumentMatch<MethodArgumentBinding>> methodArguments = new ArrayList<ArgumentMatch<MethodArgumentBinding>>();
        MethodDescriptor<Object> method = null;
        Integer methodEnd = null;
        Event previous = null;
        while (true) {
            Event event;
            if (!((event = parser.next()) instanceof Event.Separator)) {
                Event.Argument argumentEvent;
                List values;
                if (event instanceof Event.Stop) {
                    Event.Stop end = (Event.Stop)event;
                    int endIndex = previous instanceof Event.Separator ? ((Event.Separator)previous).getToken().getFrom() : end.getIndex();
                    if (method == null) {
                        classEnd = endIndex;
                        if (this.mainName != null) {
                            method = this.descriptor.getMethod(this.mainName);
                        }
                        if (method == null) break;
                        methodEnd = classEnd;
                        break;
                    }
                    methodEnd = classEnd = Integer.valueOf(endIndex);
                    break;
                }
                if (event instanceof Event.Option) {
                    Event.Option optionEvent = (Event.Option)event;
                    OptionDescriptor desc = (OptionDescriptor)optionEvent.getDescriptor();
                    ArrayList<OptionMatch<TypeBinding>> options = desc.getOwner() instanceof ClassDescriptor ? classOptions : methodOptions;
                    boolean done = false;
                    ListIterator i = options.listIterator();
                    while (i.hasNext()) {
                        OptionMatch om = (OptionMatch)i.next();
                        if (!om.getParameter().equals(desc)) continue;
                        ArrayList<LiteralValue> v = new ArrayList<LiteralValue>(om.getValues());
                        v.addAll(this.bilto(optionEvent.getValues()));
                        ArrayList<String> names = new ArrayList<String>(om.getNames());
                        names.add(optionEvent.getToken().getName());
                        i.set(new OptionMatch(desc, names, v));
                        done = true;
                        break;
                    }
                    if (!done) {
                        OptionMatch match = new OptionMatch(desc, optionEvent.getToken().getName(), this.bilto(optionEvent.getValues()));
                        options.add(match);
                    }
                } else if (event instanceof Event.Method) {
                    if (event instanceof Event.Method.Implicit) {
                        Event.Method.Implicit implicit = (Event.Method.Implicit)event;
                        classEnd = implicit.getTrigger().getFrom();
                        method = implicit.getDescriptor();
                    } else {
                        Event.Method.Explicit explicit = (Event.Method.Explicit)event;
                        classEnd = explicit.getToken().getFrom();
                        method = explicit.getDescriptor();
                    }
                } else if (event instanceof Event.Argument && (values = (argumentEvent = (Event.Argument)event).getValues()).size() > 0) {
                    ArgumentMatch match = new ArgumentMatch((ArgumentDescriptor)argumentEvent.getDescriptor(), argumentEvent.getFrom(), argumentEvent.getTo(), this.bilto(argumentEvent.getValues()));
                    if (((ArgumentDescriptor)argumentEvent.getDescriptor()).getOwner() instanceof ClassDescriptor) {
                        classArguments.add(match);
                    } else {
                        methodArguments.add(match);
                    }
                }
            }
            previous = event;
        }
        ClassMatch<T> classMatch = new ClassMatch<T>(this.descriptor, classOptions, classArguments, s.substring(classEnd));
        if (method != null) {
            return new MethodMatch<T>(classMatch, method, false, methodOptions, methodArguments, s.substring(methodEnd));
        }
        return classMatch;
    }

    private Completion argument(MethodDescriptor<?> method, Completer completer) {
        List arguments = method.getArguments();
        if (arguments.isEmpty()) {
            return new EmptyCompletion();
        }
        ArgumentDescriptor argument = arguments.get(0);
        return new ParameterCompletion("", Termination.DETERMINED, argument, completer);
    }

    @Override
    public Map<String, String> complete(Completer completer, String s) throws CmdCompletionException {
        return this._complete(completer, s).complete();
    }

    private Completion _complete(Completer completer, String s) throws CmdCompletionException {
        Event event;
        Tokenizer tokenizer = new Tokenizer(s);
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Parser.Mode.COMPLETE);
        Event last = null;
        Event.Separator separator = null;
        MethodDescriptor<Object> method = null;
        while (true) {
            if ((event = parser.next()) instanceof Event.Separator) {
                separator = (Event.Separator)event;
                continue;
            }
            if (event instanceof Event.Stop) break;
            if (event instanceof Event.Option) {
                last = event;
                separator = null;
                continue;
            }
            if (event instanceof Event.Method) {
                method = ((Event.Method)event).getDescriptor();
                last = event;
                separator = null;
                continue;
            }
            if (event instanceof Event.Argument) {
                last = event;
                separator = null;
                continue;
            }
            if (!(event instanceof Event.DoubleDash)) continue;
            last = event;
            separator = null;
        }
        Event.Stop stop = (Event.Stop)event;
        if (stop instanceof Event.Stop.Unresolved.NoSuchOption) {
            Event.Stop.Unresolved.NoSuchOption nso = (Event.Stop.Unresolved.NoSuchOption)stop;
            return new OptionCompletion(method != null ? method : this.descriptor, (Token.Literal.Option)nso.getToken());
        }
        if (stop instanceof Event.Stop.Unresolved) {
            if (stop instanceof Event.Stop.Unresolved.TooManyArguments) {
                if (method == null) {
                    Event.Stop.Unresolved.TooManyArguments tma = (Event.Stop.Unresolved.TooManyArguments)stop;
                    return new MethodCompletion(this.mainName, s.substring(stop.getIndex()), ((Token.Literal)tma.getToken()).termination);
                }
                return new EmptyCompletion();
            }
            return new EmptyCompletion();
        }
        if (stop instanceof Event.Stop.Done.Option || stop instanceof Event.Stop.Done.Arg) {
            // empty if block
        }
        if (last == null) {
            if (method == null) {
                if (((Object)this.descriptor.getSubordinates().keySet()).equals(Collections.singleton(this.mainName))) {
                    method = this.descriptor.getMethod(this.mainName);
                    List args = method.getArguments();
                    if (args.size() > 0) {
                        return new ParameterCompletion("", Termination.DETERMINED, args.get(0), completer);
                    }
                    return new EmptyCompletion();
                }
                return new MethodCompletion(this.mainName, s.substring(stop.getIndex()), Termination.DETERMINED);
            }
            return new EmptyCompletion();
        }
        if (last instanceof Event.DoubleDash) {
            Event.DoubleDash dd = (Event.DoubleDash)last;
            return new OptionCompletion(method != null ? method : this.descriptor, dd.token);
        }
        if (last instanceof Event.Option) {
            Event.Option optionEvent = (Event.Option)last;
            List values = optionEvent.getValues();
            OptionDescriptor option = (OptionDescriptor)optionEvent.getDescriptor();
            if (separator == null) {
                if (values.size() == 0) {
                    return new SpaceCompletion();
                }
                if (values.size() <= option.getArity()) {
                    Token.Literal.Word word = (Token.Literal.Word)optionEvent.peekLast();
                    return new ParameterCompletion(word.value, word.termination, option, completer);
                }
                return new EmptyCompletion();
            }
            if (values.size() < option.getArity()) {
                return new ParameterCompletion("", Termination.DETERMINED, option, completer);
            }
            if (method == null) {
                return new MethodCompletion(this.mainName, s.substring(stop.getIndex()), Termination.DETERMINED);
            }
            return this.argument(method, completer);
        }
        if (last instanceof Event.Argument) {
            Event.Argument eventArgument = (Event.Argument)last;
            ArgumentDescriptor argument = (ArgumentDescriptor)eventArgument.getDescriptor();
            if (separator != null) {
                switch (argument.getMultiplicity()) {
                    case ZERO_OR_ONE: 
                    case ONE: {
                        List arguments = argument.getOwner().getArguments();
                        int index = arguments.indexOf(argument) + 1;
                        if (index < arguments.size()) {
                            throw new UnsupportedOperationException("Need to find next argument and use it for completion");
                        }
                        return new EmptyCompletion();
                    }
                    case ZERO_OR_MORE: {
                        return new ParameterCompletion("", Termination.DETERMINED, argument, completer);
                    }
                }
                throw new AssertionError();
            }
            Object value = eventArgument.peekLast();
            return new ParameterCompletion(((Token.Literal)value).value, ((Token.Literal)value).termination, argument, completer);
        }
        if (last instanceof Event.Method) {
            if (separator != null) {
                return this.argument(method, completer);
            }
            return new SpaceCompletion();
        }
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterCompletion
    extends Completion {
        private final String prefix;
        private final Termination termination;
        private final ParameterDescriptor<?> parameter;
        private final Completer completer;

        private ParameterCompletion(String prefix, Termination termination, ParameterDescriptor<?> parameter, Completer completer) {
            this.prefix = prefix;
            this.termination = termination;
            this.parameter = parameter;
            this.completer = completer;
        }

        @Override
        protected Map<String, String> complete() throws CmdCompletionException {
            Class<Completer> completerType = this.parameter.getCompleterType();
            Completer completer = this.completer;
            if (completerType != EmptyCompleter.class) {
                try {
                    completer = completerType.newInstance();
                }
                catch (Exception e) {
                    throw new CmdCompletionException(e);
                }
            }
            if (completer != null) {
                try {
                    Map<String, Boolean> res = completer.complete(this.parameter, this.prefix);
                    HashMap<String, String> delimiter = new HashMap<String, String>();
                    for (Map.Entry<String, Boolean> entry : res.entrySet()) {
                        delimiter.put(entry.getKey(), entry.getValue() != false ? this.termination.getEnd() : "");
                    }
                    return delimiter;
                }
                catch (Exception e) {
                    throw new CmdCompletionException(e);
                }
            }
            return Collections.emptyMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OptionCompletion
    extends Completion {
        private final CommandDescriptor<T, ?> descriptor;
        private final Token.Literal.Option prefix;

        private OptionCompletion(CommandDescriptor<T, ?> descriptor, Token.Literal.Option prefix) {
            this.descriptor = descriptor;
            this.prefix = prefix;
        }

        @Override
        protected Map<String, String> complete() throws CmdCompletionException {
            HashMap<String, String> completions = new HashMap<String, String>();
            Set<String> optionNames = this.prefix instanceof Token.Literal.Option.Short ? this.descriptor.getShortOptionNames() : this.descriptor.getLongOptionNames();
            for (String optionName : optionNames) {
                if (!optionName.startsWith(this.prefix.value)) continue;
                completions.put(optionName.substring(this.prefix.value.length()), " ");
            }
            return completions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCompletion
    extends Completion {
        private final String mainName;
        private final String prefix;
        private final Termination termination;

        private MethodCompletion(String mainName, String prefix, Termination termination) {
            this.mainName = mainName;
            this.prefix = prefix;
            this.termination = termination;
        }

        @Override
        protected Map<String, String> complete() throws CmdCompletionException {
            HashMap<String, String> completions = new HashMap<String, String>();
            for (MethodDescriptor m : MatcherImpl.this.descriptor.getMethods()) {
                String name = m.getName();
                if (!name.startsWith(this.prefix) || name.equals(this.mainName)) continue;
                completions.put(name.substring(this.prefix.length()), this.termination.getEnd());
            }
            return completions;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpaceCompletion
    extends Completion {
        private SpaceCompletion() {
        }

        @Override
        protected Map<String, String> complete() throws CmdCompletionException {
            return Collections.singletonMap("", " ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmptyCompletion
    extends Completion {
        private EmptyCompletion() {
        }

        @Override
        protected Map<String, String> complete() throws CmdCompletionException {
            return Collections.emptyMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class Completion {
        private Completion() {
        }

        protected abstract Map<String, String> complete() throws CmdCompletionException;
    }
}

