/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.crsh.vfs.File;
import org.crsh.vfs.Mount;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.FSDriver;
import org.crsh.vfs.spi.file.FileDriver;
import org.crsh.vfs.spi.jarurl.JarURLDriver;
import org.crsh.vfs.spi.mount.MountDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FS {
    final List<Mount<?>> mounts = new ArrayList();

    public File get(Path path) throws IOException {
        return new File(this, path);
    }

    public <H> FS mount(FSDriver<H> driver, Path path) {
        if (driver == null) {
            throw new NullPointerException();
        }
        if (path.equals(Path.get("/"))) {
            this.mounts.add(Mount.wrap(driver));
        } else {
            this.mounts.add(Mount.wrap(new MountDriver<H>(path, driver)));
        }
        return this;
    }

    public <H> FS mount(FSDriver<H> driver, String path) {
        return this.mount(driver, Path.get(path));
    }

    public <H> FS mount(FSDriver<H> driver) {
        return this.mount(driver, "/");
    }

    public FS mount(java.io.File root) {
        return this.mount(new FileDriver(root));
    }

    public FS mount(ClassLoader cl, Path path) throws IOException, URISyntaxException {
        if (cl == null) {
            throw new NullPointerException();
        }
        if (path == null) {
            throw new NullPointerException();
        }
        if (!path.isDir()) {
            throw new IllegalArgumentException("Path " + path + " must be a dir");
        }
        Enumeration<URL> en = cl.getResources(path.getValue().substring(1));
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                java.io.File root = new java.io.File(url.toURI());
                this.mount(root);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            JarURLDriver jarDriver = new JarURLDriver(conn);
            this.mount(jarDriver, path);
        }
        return this;
    }

    public FS mount(Class<?> clazz) throws IOException, URISyntaxException {
        AbstractFSDriver driver;
        if (clazz == null) {
            throw new NullPointerException();
        }
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            driver = new FileDriver(new java.io.File(url.toURI()));
        } else if (protocol.equals("jar")) {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            driver = new JarURLDriver(conn);
        } else {
            throw new IllegalArgumentException("Protocol " + protocol + " not supported");
        }
        return this.mount(driver);
    }
}

