/*
 * Decompiled with CFR 0.152.
 */
package org.crsh;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.Processor;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.BaseTerm;
import org.crsh.term.Term;
import org.crsh.term.TestShell;
import org.crsh.term.spi.TermIO;
import org.crsh.term.spi.TestTermIO;

public class ProcessorTestCase
extends TestCase {
    private static final Shell ECHO_SHELL = new TestShell(){

        @Override
        public String getWelcome() {
            return "";
        }

        @Override
        public void process(String request, ShellProcessContext processContext) {
            processContext.begin(new ShellProcess(){

                public void cancel() {
                    throw new AssertionError();
                }
            });
            processContext.end((ShellResponse)new ShellResponse.Display(request));
        }

        @Override
        public Map<String, String> complete(String prefix) {
            return Collections.singletonMap(new StringBuilder(prefix).reverse().toString(), "");
        }
    };

    public void testLine() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("abc\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testDel() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendDel();
        controller.connector.append("\r\n");
        controller.connector.assertChars("abc");
        controller.connector.assertDel();
        controller.connector.assertCRLF();
        controller.connector.assertChars("ab");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testBreak() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("abc");
        controller.connector.appendBreak();
        controller.connector.assertChars("abc");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.append("def\r\n");
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("def");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testInsert() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendMoveLeft();
        controller.connector.append("c\r\n");
        controller.connector.assertChars("ab");
        controller.connector.assertMoveLeft();
        controller.connector.assertChars("cb");
        controller.connector.assertMoveLeft();
        controller.connector.assertCRLF();
        controller.connector.assertChars("acb");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveRight() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.appendMoveRight();
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveLeft() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.appendMoveLeft();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testMoveUp() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveUp() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveUp();
        controller.connector.appendMoveUp();
        controller.connector.assertChars("a");
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testIdempotentMoveDown() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("a");
        controller.connector.append("\r\n");
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("a");
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.connector.appendMoveDown();
        controller.connector.append("\r\n");
        controller.connector.assertCRLF();
        controller.connector.assertCRLF();
        controller.connector.assertChars("% ");
        controller.assertStop();
    }

    public void testCompletion1() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
        controller.connector.append("ab");
        controller.connector.appendTab();
        controller.connector.assertChars("abba");
    }

    public void testCompletion2() throws Exception {
        Controller controller = this.create(ECHO_SHELL);
        controller.assertStart();
    }

    private Controller create(Shell shell) throws IOException {
        return new Controller(new TestTermIO(), shell);
    }

    private class Controller
    implements Runnable {
        private volatile boolean running = true;
        private final CountDownLatch startSync = new CountDownLatch(1);
        private final CountDownLatch stopSync = new CountDownLatch(1);
        private final Thread thread = new Thread(this);
        private final TestTermIO connector;
        private final Processor processor;

        private Controller(TestTermIO connector, Shell shell) {
            this.connector = connector;
            this.processor = new Processor((Term)new BaseTerm((TermIO)connector), shell);
        }

        public void assertStart() {
            this.thread.start();
            try {
                Assert.assertTrue((boolean)this.startSync.await(1L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                AssertionFailedError afe = new AssertionFailedError();
                afe.initCause((Throwable)e);
                throw afe;
            }
            Assert.assertTrue((boolean)this.running);
            this.connector.assertCRLF();
            this.connector.assertChars("% ");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            this.startSync.countDown();
            try {
                this.processor.run();
            }
            finally {
                this.running = false;
                this.stopSync.countDown();
            }
        }

        public void assertStop() {
            Assert.assertTrue((boolean)this.running);
            this.connector.append("bye\r\n");
            this.connector.assertChars("bye");
            this.connector.assertCRLF();
        }
    }
}

