/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import junit.framework.TestCase;
import org.crsh.command.SyntaxException;
import org.crsh.shell.impl.AST;
import org.crsh.shell.impl.Parser;

public class ParserTestCase
extends TestCase {
    public void testEmpty() {
        ParserTestCase.assertNull((Object)new Parser((CharSequence)"").parse());
    }

    public void testCommand() {
        Parser p = new Parser((CharSequence)"a");
        AST.Expr e = (AST.Expr)p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.term.line);
        ParserTestCase.assertNull((Object)e.term.next);
        ParserTestCase.assertNull((Object)e.next);
    }

    public void testPlus() {
        Parser p = new Parser((CharSequence)"a+b");
        AST.Expr e = (AST.Expr)p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.term.line);
        ParserTestCase.assertEquals((String)"b", (String)e.term.next.line);
        ParserTestCase.assertNull((Object)e.term.next.next);
        ParserTestCase.assertNull((Object)e.next);
    }

    public void testPipe() {
        Parser p = new Parser((CharSequence)"a|b");
        AST.Expr e = (AST.Expr)p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.term.line);
        ParserTestCase.assertNull((Object)e.term.next);
        ParserTestCase.assertEquals((String)"b", (String)e.next.term.line);
        ParserTestCase.assertNull((Object)e.next.next);
    }

    public void testComplex() {
        Parser p = new Parser((CharSequence)"a+b|c");
        AST.Expr e = (AST.Expr)p.parse();
        ParserTestCase.assertEquals((String)"a", (String)e.term.line);
        ParserTestCase.assertEquals((String)"b", (String)e.term.next.line);
        ParserTestCase.assertNull((Object)e.term.next.next);
        ParserTestCase.assertEquals((String)"c", (String)e.next.term.line);
        ParserTestCase.assertNull((Object)e.next.next);
    }

    public void testSyntaxException() {
        this.assertSyntaxException("|");
        this.assertSyntaxException("+");
        this.assertSyntaxException("a|");
        this.assertSyntaxException("a+");
    }

    private void assertSyntaxException(String s) {
        try {
            new Parser((CharSequence)s).parse();
            ParserTestCase.fail();
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }
}

