/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.util.LineFeedWriter;

public class TreeElementTestCase
extends TestCase {
    public void testSimple() throws IOException {
        TreeElement elt = new TreeElement();
        elt.addNode((Element)new LabelElement("1\n1"));
        elt.addNode((Element)new LabelElement("2\n"));
        StringBuilder sb = new StringBuilder();
        LineFeedWriter writer = new LineFeedWriter((Appendable)sb, "_");
        elt.print((ShellWriter)writer);
        TreeElementTestCase.assertEquals((String)"+-1_| 1_+-2_", (String)sb.toString());
    }

    public void testNested() throws Exception {
        TreeElement elt = new TreeElement((Element)new LabelElement("foo"));
        elt.addNode((Element)new TreeElement((Element)new LabelElement("bar")).addNode((Element)new LabelElement("1\n1")).addNode((Element)new LabelElement("2\n2")));
        elt.addNode((Element)new TreeElement().addNode((Element)new LabelElement("3")).addNode((Element)new LabelElement("4")));
        StringBuilder sb = new StringBuilder();
        LineFeedWriter writer = new LineFeedWriter((Appendable)sb, "_");
        elt.print((ShellWriter)writer);
        TreeElementTestCase.assertEquals((String)"foo_+-bar_| +-1_| | 1_| +-2_| | 2_+-+-3_| +-4_", (String)sb.toString());
    }
}

